import json
import os
import toml
from debug import myprint
from apm_helpers.messages import Messages as msg
SETTINGS_FILE_NAME='perf_model_settings.toml'
OLD_SETTINGS_FILE_NAME='settings.toml'
class Settings:
 def __init__(self,settings_dir,old_settings_dir=None):
  self.settings_file=os.path.join(settings_dir,SETTINGS_FILE_NAME)
  self.exists=False
  if not os.path.exists(self.settings_file):
   if old_settings_dir is not None:
    old_settings_file=os.path.join(old_settings_dir,OLD_SETTINGS_FILE_NAME)
    if os.path.exists(old_settings_file):
     self.settings_file=old_settings_file
     self.exists=True
  else:
   self.exists=True
  if self.exists:
   myprint(msg.SETTINGS_FILE_EXISTS.format(self.settings_file),severity=1)
   with open(self.settings_file,'r')as f:
    self.settings=toml.load(f)
  else:
   myprint(msg.SETTINGS_FILE_DOES_NOT_EXIST.format(self.settings_file),severity=1)
   self.settings={}
 def resolve_configs(self,args):
  if self.exists:
   configs=self.settings['configs']
   if len(configs)>0 and args.use_collect_configs:
    myprint(msg.SETTINGS_CONFIG_USE.format(json.dumps(configs)),severity=2)
    return configs+args.config
  myprint(msg.SETTINGS_CONFIG_NOT_USE,severity=1)
  return args.config
 def validate_settings(self,accel,args,actual_settings):
  accel.validate_settings(args,actual_settings,self.settings,self.exists,self.settings_file)
 def validate_cli_options(self,args):
  if self.exists:
   options=self.settings['options']
   if len(options)>0 and args.use_collect_configs:
    myprint(msg.SETTINGS_CONFIG_USE.format(json.dumps(options)),severity=2)
    args.__dict__.update(options)
def save_collection_settings(settings_dir,settings):
 with open(os.path.join(settings_dir,SETTINGS_FILE_NAME),'w+')as f:
  toml.dump(settings,f)
