#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 idris
version:              1.3.4
visibility:           public
id:                   idris-1.3.4-6BjPFUr9r4F9hAjoKhakMu
key:                  idris-1.3.4-6BjPFUr9r4F9hAjoKhakMu
license:              BSD-3-Clause
maintainer:           Niklas Larsson <niklas@mm.st>
author:               Edwin Brady
stability:            Beta
homepage:             https://www.idris-lang.org/
synopsis:             Functional Programming Language with Dependent Types
description:
    Idris is a general purpose language with full dependent types.
    It is compiled, with eager evaluation.
    Dependent types allow types to be predicated on values,
    meaning that some aspects of a program'\''s behaviour can be
    specified precisely in the type. The language is closely
    related to Epigram and Agda. There is a tutorial at
    <https://www.idris-lang.org/documentation>.
    Features include:

    * Full, first class, dependent types with dependent pattern matching

    * where clauses, with rule, case expressions,
    pattern matching let and lambda bindings

    * Interfaces (similar to type classes), monad comprehensions

    * do notation, idiom brackets, syntactic conveniences for lists,
    tuples, dependent pairs

    * Totality checking

    * Coinductive types

    * Indentation significant syntax, extensible syntax

    * Cumulative universes

    * Simple foreign function interface (to C)

    * Hugs style interactive environment

category:             Compilers/Interpreters, Dependent Types
abi:                  c8790e3dae35ed0b86dfaa117f8f7970
exposed:              True
exposed-modules:
    IRTS.Bytecode IRTS.CodegenC IRTS.CodegenCommon
    IRTS.CodegenJavaScript IRTS.Compiler IRTS.Defunctionalise
    IRTS.DumpBC IRTS.Exports IRTS.Inliner IRTS.JavaScript.AST
    IRTS.JavaScript.Codegen IRTS.JavaScript.LangTransforms
    IRTS.JavaScript.Name IRTS.JavaScript.PrimOp
    IRTS.JavaScript.Specialize IRTS.Lang IRTS.LangOpts IRTS.Portable
    IRTS.Simplified IRTS.System Idris.ASTUtils Idris.AbsSyntax
    Idris.AbsSyntaxTree Idris.Apropos Idris.CaseSplit Idris.Chaser
    Idris.CmdOptions Idris.Colours Idris.Completion Idris.Core.Binary
    Idris.Core.CaseTree Idris.Core.Constraints Idris.Core.DeepSeq
    Idris.Core.Elaborate Idris.Core.Evaluate Idris.Core.Execute
    Idris.Core.ProofState Idris.Core.ProofTerm Idris.Core.TT
    Idris.Core.Typecheck Idris.Core.Unify Idris.Core.WHNF
    Idris.Coverage Idris.DSL Idris.DataOpts Idris.DeepSeq
    Idris.Delaborate Idris.Directives Idris.Docs Idris.Docstrings
    Idris.Elab.AsPat Idris.Elab.Clause Idris.Elab.Data
    Idris.Elab.Implementation Idris.Elab.Interface Idris.Elab.Provider
    Idris.Elab.Quasiquote Idris.Elab.Record Idris.Elab.Rewrite
    Idris.Elab.RunElab Idris.Elab.Term Idris.Elab.Transform
    Idris.Elab.Type Idris.Elab.Utils Idris.Elab.Value Idris.ElabDecls
    Idris.Erasure Idris.ErrReverse Idris.Error Idris.Help Idris.IBC
    Idris.IdeMode Idris.IdrisDoc Idris.Imports Idris.Info
    Idris.Info.Show Idris.Inliner Idris.Interactive Idris.Main
    Idris.ModeCommon Idris.Options Idris.Output Idris.Package
    Idris.Package.Common Idris.Package.Parser Idris.Parser
    Idris.Parser.Data Idris.Parser.Expr Idris.Parser.Helpers
    Idris.Parser.Ops Idris.Parser.Stack Idris.PartialEval
    Idris.Primitives Idris.ProofSearch Idris.Prover Idris.Providers
    Idris.REPL Idris.REPL.Browse Idris.REPL.Commands Idris.REPL.Parser
    Idris.Reflection Idris.Termination Idris.Transforms
    Idris.TypeSearch Idris.Unlit Idris.WhoCalls Util.DynamicLinker
    Util.ScreenSize Util.System

hidden-modules:
    Util.Pretty Util.Net Paths_idris Version_idris Tools_idris
    BuildFlags_idris

import-dirs:          /usr/lib/ghc-9.6.6/site-local/idris-1.3.4
library-dirs:         /usr/lib/ghc-9.6.6/site-local/idris-1.3.4
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/idris-1.3.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/idris
hs-libraries:         HSidris-1.3.4-6BjPFUr9r4F9hAjoKhakMu
extra-libraries:      gmp
depends:
    aeson-2.1.2.1-2mQErQ8BnomI9IyqbCda9E
    annotated-wl-pprint-0.7.0-GFWp72SduKx5Zv0YaM2sPQ
    ansi-terminal-1.0.2-BPjCUZulbk02l8COiFLYJh
    ansi-wl-pprint-1.0.2-4O0Ceywxuw6Jfi3uDtYxbF array-0.5.6.0
    async-2.2.5-7rznh9Npau1HJJ6XeEC4Wn base-4.18.2.1
    base64-bytestring-1.2.1.0-yECTd8pImc5tCLSmRqH7t binary-0.8.9.1
    blaze-html-0.9.2.0-8CIOWujpLcd2fSwCqkXFhk
    blaze-markup-0.8.3.0-8CtErBAglJMDcY5YauRCvR bytestring-0.11.5.3
    cheapskate-0.1.1.2-JG87TXib0tSE636oG6UJIT
    code-page-0.2.1-8r7bPp8D9hK7XmJl89SAkA containers-0.6.7
    deepseq-1.4.8.1 directory-1.3.8.5 filepath-1.4.300.1
    fingertree-0.1.6.2-Ds4jz71tzdy7cnCCdyMwfR
    fsnotify-0.4.4.0-5j0CJGesdV1Kh4BxLHK4tE haskeline-0.8.2.1
    ieee754-0.8.0-EGVgNa4vggOEmRT3C9pqtp
    libffi-0.2.1-6RvgivFZ04x2a0O1QsDmY2
    megaparsec-9.7.0-7dpjbIWxHj2jHxEtJpJqK mtl-2.3.1
    network-3.1.4.0-IebBekr390i8Nw6inuvzzb
    optparse-applicative-0.18.1.0-GNgTM1Z51EJ46yTCRGWgwm
    parser-combinators-1.3.0-20UTEUZ5CKDJdRu747ID48 pretty-1.1.3.6
    process-1.6.19.0 regex-tdfa-1.3.2.5-LVEu1APtYIwJMYGWcCftyg
    safe-0.3.21-J8yTbFjKPpT3oBMPyWIsQW
    split-0.2.5-KeBcC7WBTCHE2olxjxkqgK
    terminal-size-0.3.4-RfZxi4foNwK9w669pzI7h text-2.0.2 time-1.12.2
    transformers-0.6.1.0 uniplate-1.6.13-6kDUZZ5j46F5aRcYe9y82s
    unix-2.8.4.0 unordered-containers-0.2.20.1-LJBbYvuM7Af6ez80tefkUA
    utf8-string-1.0.2-4PcjKdTUnsVIUZCxTUoFbK
    vector-0.13.2.0-6vtrErFI1tV1Z02auPMCSS
    vector-binary-instances-0.2.5.2-B35LJcM7kDk6ex2gWZqScg
    zip-archive-0.4.3.2-56IrxYKWMTyAnkqfn1jj5u

haddock-interfaces:   /usr/share/doc/idris/html/idris.haddock
haddock-html:         /usr/share/doc/idris/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

