#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 idris
version:              1.3.4
visibility:           public
id:                   idris-1.3.4-Ltz360Qr1Bv9MayFW38Mxl
key:                  idris-1.3.4-Ltz360Qr1Bv9MayFW38Mxl
license:              BSD-3-Clause
maintainer:           Niklas Larsson <niklas@mm.st>
author:               Edwin Brady
stability:            Beta
homepage:             https://www.idris-lang.org/
synopsis:             Functional Programming Language with Dependent Types
description:
    Idris is a general purpose language with full dependent types.
    It is compiled, with eager evaluation.
    Dependent types allow types to be predicated on values,
    meaning that some aspects of a program'\''s behaviour can be
    specified precisely in the type. The language is closely
    related to Epigram and Agda. There is a tutorial at
    <https://www.idris-lang.org/documentation>.
    Features include:

    * Full, first class, dependent types with dependent pattern matching

    * where clauses, with rule, case expressions,
    pattern matching let and lambda bindings

    * Interfaces (similar to type classes), monad comprehensions

    * do notation, idiom brackets, syntactic conveniences for lists,
    tuples, dependent pairs

    * Totality checking

    * Coinductive types

    * Indentation significant syntax, extensible syntax

    * Cumulative universes

    * Simple foreign function interface (to C)

    * Hugs style interactive environment

category:             Compilers/Interpreters, Dependent Types
abi:                  2367d7cdd25626a28acf8e080e945e1e
exposed:              True
exposed-modules:
    IRTS.Bytecode IRTS.CodegenC IRTS.CodegenCommon
    IRTS.CodegenJavaScript IRTS.Compiler IRTS.Defunctionalise
    IRTS.DumpBC IRTS.Exports IRTS.Inliner IRTS.JavaScript.AST
    IRTS.JavaScript.Codegen IRTS.JavaScript.LangTransforms
    IRTS.JavaScript.Name IRTS.JavaScript.PrimOp
    IRTS.JavaScript.Specialize IRTS.Lang IRTS.LangOpts IRTS.Portable
    IRTS.Simplified IRTS.System Idris.ASTUtils Idris.AbsSyntax
    Idris.AbsSyntaxTree Idris.Apropos Idris.CaseSplit Idris.Chaser
    Idris.CmdOptions Idris.Colours Idris.Completion Idris.Core.Binary
    Idris.Core.CaseTree Idris.Core.Constraints Idris.Core.DeepSeq
    Idris.Core.Elaborate Idris.Core.Evaluate Idris.Core.Execute
    Idris.Core.ProofState Idris.Core.ProofTerm Idris.Core.TT
    Idris.Core.Typecheck Idris.Core.Unify Idris.Core.WHNF
    Idris.Coverage Idris.DSL Idris.DataOpts Idris.DeepSeq
    Idris.Delaborate Idris.Directives Idris.Docs Idris.Docstrings
    Idris.Elab.AsPat Idris.Elab.Clause Idris.Elab.Data
    Idris.Elab.Implementation Idris.Elab.Interface Idris.Elab.Provider
    Idris.Elab.Quasiquote Idris.Elab.Record Idris.Elab.Rewrite
    Idris.Elab.RunElab Idris.Elab.Term Idris.Elab.Transform
    Idris.Elab.Type Idris.Elab.Utils Idris.Elab.Value Idris.ElabDecls
    Idris.Erasure Idris.ErrReverse Idris.Error Idris.Help Idris.IBC
    Idris.IdeMode Idris.IdrisDoc Idris.Imports Idris.Info
    Idris.Info.Show Idris.Inliner Idris.Interactive Idris.Main
    Idris.ModeCommon Idris.Options Idris.Output Idris.Package
    Idris.Package.Common Idris.Package.Parser Idris.Parser
    Idris.Parser.Data Idris.Parser.Expr Idris.Parser.Helpers
    Idris.Parser.Ops Idris.Parser.Stack Idris.PartialEval
    Idris.Primitives Idris.ProofSearch Idris.Prover Idris.Providers
    Idris.REPL Idris.REPL.Browse Idris.REPL.Commands Idris.REPL.Parser
    Idris.Reflection Idris.Termination Idris.Transforms
    Idris.TypeSearch Idris.Unlit Idris.WhoCalls Util.DynamicLinker
    Util.ScreenSize Util.System

hidden-modules:
    Util.Pretty Util.Net Paths_idris Version_idris Tools_idris
    BuildFlags_idris

import-dirs:          /usr/lib/ghc-9.4.8/site-local/idris-1.3.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/idris-1.3.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/idris-1.3.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/idris
hs-libraries:         HSidris-1.3.4-Ltz360Qr1Bv9MayFW38Mxl
extra-libraries:      gmp
depends:
    aeson-2.1.2.1-LDc25PpdH5WHlLB8Mcp2Rh
    annotated-wl-pprint-0.7.0-Bbb9GOQJoVZEpSwInbNN3i
    ansi-terminal-1.0.2-9C7TLPMqFC3EnANnfcyKas
    ansi-wl-pprint-1.0.2-KP9Bn1AfSrMGWMTZm5pJQp array-0.5.4.0
    async-2.2.5-3On0Vdlc3urBKBpRPAboKf base-4.17.2.1
    base64-bytestring-1.2.1.0-7XHgmf0PZMy7LO91awCYGH binary-0.8.9.1
    blaze-html-0.9.2.0-FWwbx2kwK4a9cGj7dIEiyC
    blaze-markup-0.8.3.0-LhctOnkfqfP7twZcowViz5 bytestring-0.11.5.3
    cheapskate-0.1.1.2-KDuOzfEJ5DG8WM03el7Nvs
    code-page-0.2.1-LeQPy5FeQvS92HSQRBnpzj containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    fingertree-0.1.6.2-KNEOMYCBy9RJydYWYEiZ90
    fsnotify-0.4.3.0-2DTMLThA3PV8XrSJG0KtVX haskeline-0.8.2
    ieee754-0.8.0-ASOHKK3CShAKvOX7rImTkX
    libffi-0.2.1-DPsLfzr2gvt1V2FBULxP58
    megaparsec-9.7.0-AMbJQB9BzBxf81g5ZS6Op mtl-2.2.2
    network-3.1.4.0-L5Z9Li45X29DmnCadSsbZW
    optparse-applicative-0.18.1.0-5z7uKq3kDhiFdyVMsq5grp
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav pretty-1.1.3.6
    process-1.6.18.0 regex-tdfa-1.3.2.4-Ad5TdY6WlXxFUwxGz6iFnw
    safe-0.3.21-4A1yMugax9JCQWzW2mE78Z
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV
    terminal-size-0.3.4-G9QKE0nIH70HWdqrMvHn0A text-2.0.2 time-1.12.2
    transformers-0.5.6.2 uniplate-1.6.13-98fOhlqW0XqJefmRDJ9Z2w
    unix-2.7.3 unordered-containers-0.2.20-Cw2Ec4BgC4sInKE4e5RLSk
    utf8-string-1.0.2-FAQSGuIUGqDKZx6mH04y15
    vector-0.13.2.0-3jopdCx3MMLHVSrvHoDH9i
    vector-binary-instances-0.2.5.2-CQn2R5THNOf542iqjxSrjP
    zip-archive-0.4.3.2-AL8aXY7DfkeAmcyhvIVL7Q

haddock-interfaces:   /usr/share/doc/idris/html/idris.haddock
haddock-html:         /usr/share/doc/idris/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

