#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 idris
version:              1.3.4
visibility:           public
id:                   idris-1.3.4-8ncf6cqk9GU2Obw9g5cldG
key:                  idris-1.3.4-8ncf6cqk9GU2Obw9g5cldG
license:              BSD-3-Clause
maintainer:           Niklas Larsson <niklas@mm.st>
author:               Edwin Brady
stability:            Beta
homepage:             https://www.idris-lang.org/
synopsis:             Functional Programming Language with Dependent Types
description:
    Idris is a general purpose language with full dependent types.
    It is compiled, with eager evaluation.
    Dependent types allow types to be predicated on values,
    meaning that some aspects of a program'\''s behaviour can be
    specified precisely in the type. The language is closely
    related to Epigram and Agda. There is a tutorial at
    <https://www.idris-lang.org/documentation>.
    Features include:

    * Full, first class, dependent types with dependent pattern matching

    * where clauses, with rule, case expressions,
    pattern matching let and lambda bindings

    * Interfaces (similar to type classes), monad comprehensions

    * do notation, idiom brackets, syntactic conveniences for lists,
    tuples, dependent pairs

    * Totality checking

    * Coinductive types

    * Indentation significant syntax, extensible syntax

    * Cumulative universes

    * Simple foreign function interface (to C)

    * Hugs style interactive environment

category:             Compilers/Interpreters, Dependent Types
abi:                  4d372217447d46152ac7d130f7303829
exposed:              True
exposed-modules:
    IRTS.Bytecode IRTS.CodegenC IRTS.CodegenCommon
    IRTS.CodegenJavaScript IRTS.Compiler IRTS.Defunctionalise
    IRTS.DumpBC IRTS.Exports IRTS.Inliner IRTS.JavaScript.AST
    IRTS.JavaScript.Codegen IRTS.JavaScript.LangTransforms
    IRTS.JavaScript.Name IRTS.JavaScript.PrimOp
    IRTS.JavaScript.Specialize IRTS.Lang IRTS.LangOpts IRTS.Portable
    IRTS.Simplified IRTS.System Idris.ASTUtils Idris.AbsSyntax
    Idris.AbsSyntaxTree Idris.Apropos Idris.CaseSplit Idris.Chaser
    Idris.CmdOptions Idris.Colours Idris.Completion Idris.Core.Binary
    Idris.Core.CaseTree Idris.Core.Constraints Idris.Core.DeepSeq
    Idris.Core.Elaborate Idris.Core.Evaluate Idris.Core.Execute
    Idris.Core.ProofState Idris.Core.ProofTerm Idris.Core.TT
    Idris.Core.Typecheck Idris.Core.Unify Idris.Core.WHNF
    Idris.Coverage Idris.DSL Idris.DataOpts Idris.DeepSeq
    Idris.Delaborate Idris.Directives Idris.Docs Idris.Docstrings
    Idris.Elab.AsPat Idris.Elab.Clause Idris.Elab.Data
    Idris.Elab.Implementation Idris.Elab.Interface Idris.Elab.Provider
    Idris.Elab.Quasiquote Idris.Elab.Record Idris.Elab.Rewrite
    Idris.Elab.RunElab Idris.Elab.Term Idris.Elab.Transform
    Idris.Elab.Type Idris.Elab.Utils Idris.Elab.Value Idris.ElabDecls
    Idris.Erasure Idris.ErrReverse Idris.Error Idris.Help Idris.IBC
    Idris.IdeMode Idris.IdrisDoc Idris.Imports Idris.Info
    Idris.Info.Show Idris.Inliner Idris.Interactive Idris.Main
    Idris.ModeCommon Idris.Options Idris.Output Idris.Package
    Idris.Package.Common Idris.Package.Parser Idris.Parser
    Idris.Parser.Data Idris.Parser.Expr Idris.Parser.Helpers
    Idris.Parser.Ops Idris.Parser.Stack Idris.PartialEval
    Idris.Primitives Idris.ProofSearch Idris.Prover Idris.Providers
    Idris.REPL Idris.REPL.Browse Idris.REPL.Commands Idris.REPL.Parser
    Idris.Reflection Idris.Termination Idris.Transforms
    Idris.TypeSearch Idris.Unlit Idris.WhoCalls Util.DynamicLinker
    Util.ScreenSize Util.System

hidden-modules:
    Util.Pretty Util.Net Paths_idris Version_idris Tools_idris
    BuildFlags_idris

import-dirs:          /usr/lib/ghc-9.4.8/site-local/idris-1.3.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/idris-1.3.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/idris-1.3.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/idris
hs-libraries:         HSidris-1.3.4-8ncf6cqk9GU2Obw9g5cldG
extra-libraries:      gmp
depends:
    aeson-2.1.2.1-HUj8Ou2Jrr19darX8iyQt4
    annotated-wl-pprint-0.7.0-Bbb9GOQJoVZEpSwInbNN3i
    ansi-terminal-1.0.2-BmYwE3CMMeiHUDLKLgejP7
    ansi-wl-pprint-1.0.2-74eftpNLNhoAHGBf8k40U5 array-0.5.4.0
    async-2.2.5-JsOMVyOozRP6jACwcJZjUc base-4.17.2.1
    base64-bytestring-1.2.1.0-IbCUnYF5PxIJ57HxqijudZ binary-0.8.9.1
    blaze-html-0.9.2.0-9ouvNI0LGvR8T2YDANh957
    blaze-markup-0.8.3.0-H4QAcgAuzx9AWvBQPdzmLl bytestring-0.11.5.3
    cheapskate-0.1.1.2-ISLCtEtaoiv1DiSq6OhHc
    code-page-0.2.1-LeQPy5FeQvS92HSQRBnpzj containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    fingertree-0.1.6.2-AAkya2mig1Z6rI2PO8JTfr
    fsnotify-0.4.2.0-40fhfHvU9zmJ3byciATski haskeline-0.8.2
    ieee754-0.8.0-ASOHKK3CShAKvOX7rImTkX
    libffi-0.2.1-DPsLfzr2gvt1V2FBULxP58
    megaparsec-9.6.1-EEBj4pRLerNCeJDumClMn7 mtl-2.2.2
    network-3.1.4.0-9WwAYDZyp2nAB4XV6sI63l
    optparse-applicative-0.18.1.0-HLRS0wxhkSb4kVPN7e82uH
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav pretty-1.1.3.6
    process-1.6.18.0 regex-tdfa-1.3.2.4-1rXqUz52vb5BdcUf9c7mO2
    safe-0.3.21-LwDGcPt9fP72KP4K2XydmJ
    split-0.2.5-B9q8eJqGWtOKQzzX1ITTGf
    terminal-size-0.3.4-G9QKE0nIH70HWdqrMvHn0A text-2.0.2 time-1.12.2
    transformers-0.5.6.2 uniplate-1.6.13-CRjlMP0C2Cu6zc8VNXTQBv
    unix-2.7.3 unordered-containers-0.2.20-obNV32ZSreHxgWRz6JrKP
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    vector-0.13.2.0-GDtmlcfK9QZ7E5AlTQVnIi
    vector-binary-instances-0.2.5.2-6v3UXhPE8ADKIbAWBQGy1o
    zip-archive-0.4.3.2-4Yjy5u70TDZId6NFRr6bzW

haddock-interfaces:   /usr/share/doc/idris/html/idris.haddock
haddock-html:         /usr/share/doc/idris/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

