#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.43.1
visibility:           public
id:                   hledger-web-1.43.1-5vJHpeXgYYKFY4RlzQT7nM
key:                  hledger-web-1.43.1-5vJHpeXgYYKFY4RlzQT7nM
license:              GPL-3.0-or-later
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  1205665ad4e86589bf2666bbb6af7bb5
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.43.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.43.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.43.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.43.1-5vJHpeXgYYKFY4RlzQT7nM
depends:
    Decimal-0.5.2-ADJPCZS47DJ5ovz6xCyVW8
    aeson-2.1.2.1-9rGsBPhyshTKvPzkopJx8r base-4.17.2.1
    base64-1.0-J0oTLxy55BtDTG0iNODY7T
    blaze-html-0.9.2.0-A6Vi4VW5MkkDRUuOYiyz4t
    blaze-markup-0.8.3.0-4OBPTc45d0P9Dl7KWqlGv6 bytestring-0.11.5.3
    case-insensitive-1.2.1.0-4HYxnyEi2mnBK2ectdARDN
    clientsession-0.9.3.0-Ik52npkUJcGBMeQ9YnT0YY
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-7LhvtPy5XPV4LCu4wfXMeP
    conduit-extra-1.3.8-BIrQCx2fsV2HdQedayYVqN containers-0.6.7
    data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd directory-1.3.7.1
    extra-1.7.16-OM7JeG07e46segIIOxZE2
    file-embed-0.0.16.0-FS79AECsQN660bIXAMLGHY filepath-1.4.2.2
    githash-0.1.6.3-IyQdCtc25axEz57zNYlLde
    hjsmin-0.2.1-FlblBmsMNZ9GkgjPS8ASw8
    hledger-1.43.1-4BQ3yysJ2528Huzmlb7qXS
    hledger-lib-1.43.1-6PLCPi4kkxp4lW7hKLbPYI
    hspec-2.11.3-JMhJ3K7nEsY7tLwxSVS7VA
    http-client-0.7.19-Gua32WeuAi7LtpDxdNLHZk
    http-conduit-2.3.9.1-7ptmt7HWTVU7WtzZcC0wnA
    http-types-0.12.4-5kbj0Cv0rp8HNRwQfelhRA
    megaparsec-9.7.0-7bO8AQZUPYG8DZNgIOSDEX mtl-2.2.2
    network-3.1.4.0-7fNpNYdJiSEL43akp61gqU
    safe-0.3.21-h7eXfPvXuk1aMCYRfiuDr
    shakespeare-2.1.4-CSsRCgd2cToHBTPAo8d1gt template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-6c2cEqPZKnV3oQxTlqkOug
    unordered-containers-0.2.20.1-LlrDkEbe6ka5Vid8Nf7fMl
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-HbGzj3ODjKy9gf24pBgAvG
    wai-cors-0.2.7-2pvUJWvkRs5CQhPr7rIv7F
    wai-extra-3.1.18-EcRX4hxSfOt7Zv8HDVZhj
    wai-handler-launch-3.0.3.1-fLNKxjbsk9D1JZk8V5bbD
    warp-3.3.31-EuVFpHL4tC8B6O3zETiGa1
    yaml-0.11.11.2-A24Vc8AbuOD79YcMIVAzYx
    yesod-1.6.2.1-5PlRXHseKSbDPgeTfdcLpL
    yesod-core-1.6.27.1-JsHcT7UOd2O8TZEvBtMu6b
    yesod-form-1.7.9-55WvusJM2iI1fVaeobUK42
    yesod-static-1.6.1.0-3DcP7oCvalT2wo4rMMP5KU
    yesod-test-1.6.23-KR9XA5028Q250xgJQflh6b

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

