#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.43.1
visibility:           public
id:                   hledger-web-1.43.1-7lgWoaWYhok5uFmx0U2hwJ
key:                  hledger-web-1.43.1-7lgWoaWYhok5uFmx0U2hwJ
license:              GPL-3.0-or-later
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  714b240aa50bd15c72dcb3a9b670f9c3
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.43.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.43.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.43.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.43.1-7lgWoaWYhok5uFmx0U2hwJ
depends:
    Decimal-0.5.2-8KvRBgYVQHe3AMb0jb0fUL
    aeson-2.1.2.1-6h5MFvBT17H5yplsTy4ABm base-4.17.2.1
    base64-1.0-HLYaV7YvnXz76I81CIdYJE
    blaze-html-0.9.2.0-HtuITEJLeBV807zyf9AYJy
    blaze-markup-0.8.3.0-6IdQvNChVYMC2rukwZbaTG bytestring-0.11.5.3
    case-insensitive-1.2.1.0-rTys5srD4l50KQCiQKWYt
    clientsession-0.9.3.0-IME6lrWQzeNB7AjxcnZ6TG
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-I3Yz95F3VB23prC9ONLqsR
    conduit-extra-1.3.8-L5aEVN7ERPaAM0AjK09rWN containers-0.6.7
    data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd directory-1.3.7.1
    extra-1.7.16-4PSPnwgFT0S5iaiPzXfiD0
    file-embed-0.0.16.0-FS79AECsQN660bIXAMLGHY filepath-1.4.2.2
    githash-0.1.6.3-5O9G7FreM7sKSaKcSAvTo5
    hjsmin-0.2.1-DQiO8oFv01GCWqKMCYL2TA
    hledger-1.43.1-2UzQ7DZfrCW3WUKIwUyIen
    hledger-lib-1.43.1-CHyzwGOVTnx8JfiKYvgNwv
    hspec-2.11.3-Knxe7Je4fHXBrfWW4dDy2s
    http-client-0.7.19-1818a0SJLwXE4QrSYiVT7V
    http-conduit-2.3.9.1-9rm6EpSCOWt5nDJEmvqGWw
    http-types-0.12.4-8KsSLLTB3zVcsjL7f3kez
    megaparsec-9.7.0-FpJKK1G9cbN77HLJbKTZuE mtl-2.2.2
    network-3.1.4.0-5tdSDQBC1SF9do6vOgsoy3
    safe-0.3.21-Esyyru5CUzTFDSdkcA7Wuj
    shakespeare-2.1.4-BMdBVkWIbks6G78SRtx7YK template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-9iy3Mma5ULC2KPJCZc9N5C
    unordered-containers-0.2.20-2N1fR83O3bC5qS2nrjaL2B
    utf8-string-1.0.2-Kx3GnjsHBwcIRYSetT14kb
    wai-3.2.4-IDOjyIeGcOSAX1FlCquc7y
    wai-cors-0.2.7-2hN9WbD1k966TKuZKjILMS
    wai-extra-3.1.18-GcW9oQm2YP62M9iANrm1bU
    wai-handler-launch-3.0.3.1-HYMw0NVXW2RD0TAoUvAb3E
    warp-3.3.31-6p9Y7jD8WjlDSdbFxROcM5
    yaml-0.11.11.2-AJ3kNAum5dn8G6gDSVC1fL
    yesod-1.6.2.1-75EDLNzJtUHA4hxIkQPlxV
    yesod-core-1.6.27.1-752AQN6NUV2EtrDPQGDVsf
    yesod-form-1.7.9-99XC5O8PNkb88xelua3idl
    yesod-static-1.6.1.0-2x7SGnx63c4EoeU9x3kXkZ
    yesod-test-1.6.23-4251hufgZA68GzHR8IbyRc

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

