#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.43.1
visibility:           public
id:                   hledger-web-1.43.1-D1oT5dMASrl8aq1p0dZzxC
key:                  hledger-web-1.43.1-D1oT5dMASrl8aq1p0dZzxC
license:              GPL-3.0-or-later
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  68cca936da3996937e6aa309024f5d9e
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.43.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.43.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.43.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.43.1-D1oT5dMASrl8aq1p0dZzxC
depends:
    Decimal-0.5.2-B3tMmlBSYIv6OiUJrzSwD6
    aeson-2.1.2.1-3LOl3stht3x9JybSpHkoQT base-4.17.2.1
    base64-1.0-1ZFKAokIvao1kDqJUnZjYM
    blaze-html-0.9.2.0-HlrZxLZUUWY3inTlediNEQ
    blaze-markup-0.8.3.0-6AYgqQnfYPABrBcyzVLRLw bytestring-0.11.5.3
    case-insensitive-1.2.1.0-DLRBsz9VfqUNwIWg4HsHR
    clientsession-0.9.3.0-CuipWrWwXJ3GqSqq2kR2g7
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-EW1DZSLxYltGXIcrYWVDWp
    conduit-extra-1.3.8-DOUKw0fE0l5Jtslu93zZRD containers-0.6.7
    data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd directory-1.3.7.1
    extra-1.7.16-JyMOdhEd59KIQI07ipQVcv
    file-embed-0.0.16.0-FS79AECsQN660bIXAMLGHY filepath-1.4.2.2
    githash-0.1.6.3-F2t5FCKeket9pA3b0xMoQY
    hjsmin-0.2.1-9TRt1Hw9xOqDdQpY8jMTdE
    hledger-1.43.1-GQiZ4IZLgWIJp8mRKEeqMu
    hledger-lib-1.43.1-6fgTLCPnSJw4Boi5EjB8QD
    hspec-2.11.3-34tKFAZ1BmRHyTkuI4VE9k
    http-client-0.7.19-Je5Ncol09LTKkFF5WfHhv1
    http-conduit-2.3.9.1-ACc0PY7fQ3546ONqFA19yU
    http-types-0.12.4-6ojMayzAfwB91OTgOklzJ2
    megaparsec-9.7.0-FV2beEugwl3FKVu1jTXjCD mtl-2.2.2
    network-3.1.4.0-1n8WDlzhAQUHYfqI16mYdv
    safe-0.3.21-DkSUsNQd5PECw0GboXg9Ze
    shakespeare-2.1.7-7nV3SnSvCQu8cYuCxUCup5 template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-G7N3YUAqErrKsmfQ3ZzWXl
    unordered-containers-0.2.20.1-98Hg6PuNW0XDqLHXL1727Z
    utf8-string-1.0.2-4OrQf1vZkgOAJqnDO7nv41
    wai-3.2.4-HXL0p0WqRSGJXNDZnyl0Hj
    wai-cors-0.2.7-3oTB00UGbeXAqA7rjIdvDo
    wai-extra-3.1.18-a3N8VoGXAg5KBaSqy8NBc
    wai-handler-launch-3.0.3.1-5NbFiGY9BUF7bkm7F8WwSd
    warp-3.4.0-9odkFZsHMyT9nAjq8C8gI1
    yaml-0.11.11.2-Cd6mVxIORdjI2M1tHsruv6
    yesod-1.6.2.1-Ge9xV1XtMFEIcyufQR8FJN
    yesod-core-1.6.27.1-JrAQBWNCdcm35oMB6Jg22M
    yesod-form-1.7.9-6JWmiZgPHWMH7ShUrCcpFr
    yesod-static-1.6.1.0-6wCsoZa5rJxD2z1zSq9xHf
    yesod-test-1.6.23-8M4hrLG7wIGELN8PJ3EJW8

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

