#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.42.2
visibility:           public
id:                   hledger-web-1.42.2-KX6XlXMIHD6GR75H2GDGlU
key:                  hledger-web-1.42.2-KX6XlXMIHD6GR75H2GDGlU
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  5abc99a46fafc3627d7965a2d7d23751
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.42.2-KX6XlXMIHD6GR75H2GDGlU
depends:
    Decimal-0.5.2-9mQhlsg54rVHyyIstbewRt
    aeson-2.1.2.1-AErwMfn2r5g1Pc6FekWoJb base-4.17.2.1
    base-compat-0.14.1-EDnSvJBeGTDBBfh2KFPKKz
    base64-1.0-HJjRaQL3UQT8W17ATF3qCj
    blaze-html-0.9.2.0-FBLNV7ZdEiX1CRroFdfhP1
    blaze-markup-0.8.3.0-ErSrRvmFiTqgYHgGjH7r3 bytestring-0.11.5.3
    case-insensitive-1.2.1.0-AMgBCf5fDYf4pbGdLaLtss
    clientsession-0.9.3.0-4IJVgKesu9XLfcJAzkvv3C
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-CtNjiY6d9ioJN2CqltSeEi
    conduit-extra-1.3.8-E6affjwsmt94hD5QSBQcbY containers-0.6.7
    data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd directory-1.3.7.1
    extra-1.7.16-3h3A56u6pun39B092rquhI filepath-1.4.2.2
    githash-0.1.6.3-JMIH8bGGxq4JjQF4ufytkZ
    hjsmin-0.2.1-7oAWh6v7hCP8gB8nOUc2Ca
    hledger-1.42.2-KxCpxeE223a1beqPAwluwH
    hledger-lib-1.42.2-H1y5Kip97VEDDT7LsEGsGn
    hspec-2.11.3-4NdBUI01yhNBDt0uNf7DiI
    http-client-0.7.19-4UbGlDhlNmJ9JhWVX5eNPs
    http-conduit-2.3.9.1-38o9uLhBWEf6IGiqceM3mp
    http-types-0.12.4-8EgajALSM5xB8GFkN9ClFd
    megaparsec-9.7.0-ATzV0kIhS1c1WF6GxcAl4n mtl-2.2.2
    network-3.1.4.0-Ez30o8Wyt6m7hXZSCgqaWo
    safe-0.3.21-JY11j08EGF0I8tPaNSusR6
    shakespeare-2.1.4-4PJgJrCH8EmHC53xfWJnKr template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-DzNkTFZTZy3DoMPfVsxmLG
    unordered-containers-0.2.20-2t1vPVJZrFoJrApu3o7oBM
    utf8-string-1.0.2-LtGEIYPp5RR87I6rMd4Fpy
    wai-3.2.4-6pK67aQEgpK6NKWKR3cfH5
    wai-cors-0.2.7-EmPlOjwcMnr3hQO51Y9zqs
    wai-extra-3.1.18-1tfdbAJV9Gy4Jw0YLhwxdu
    wai-handler-launch-3.0.3.1-6uf4orQoLQJEUKUiVRCkNn
    warp-3.3.31-HAfndp4WAc4EqpiqmpCSJH
    yaml-0.11.11.2-Jvc0ApySr5o80fV68nxKXR
    yesod-1.6.2.1-HYR6PdqFKpm3LtpvaDBWtJ
    yesod-core-1.6.27.1-A6x6GWdB0IvGBKOn0GLDJU
    yesod-form-1.7.9-HOoX9ACDwBMIKlXeJLORya
    yesod-static-1.6.1.0-Gl4bJ6kpx3ZKhkOrAhmouc
    yesod-test-1.6.23-4RBjgT1naRh41tInut3sbz

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

