#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.42.2
visibility:           public
id:                   hledger-web-1.42.2-7qTXHXbmfcQ9ib1NZN0Op6
key:                  hledger-web-1.42.2-7qTXHXbmfcQ9ib1NZN0Op6
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  63d1b0b8894e610899b721261d7d9117
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.42.2-7qTXHXbmfcQ9ib1NZN0Op6
depends:
    Decimal-0.5.2-7CX8FNXcQSJ7kH0syrt9SL
    aeson-2.1.2.1-FLNpA1kYfSp7ISjZQSk2AY base-4.17.2.1
    base-compat-0.14.1-EDnSvJBeGTDBBfh2KFPKKz
    base64-1.0-3Oh4cLk1DLi4M3qOrkeiIw
    blaze-html-0.9.2.0-JJrFCr8DvKJ7H4iqC8zkVN
    blaze-markup-0.8.3.0-25AsAEbi3IjBxGiBoxEVPW bytestring-0.11.5.3
    case-insensitive-1.2.1.0-1npN6GIJCWqp0RBxHaC5s
    clientsession-0.9.3.0-FJn22W8dUsOtOj6LpuXSr
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-9vefuhKp6h51CmtiJP6Shb
    conduit-extra-1.3.8-ANueX4hFp948J4326oZ5wg containers-0.6.7
    data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd directory-1.3.7.1
    extra-1.7.16-GvMs5PROjikpWrwl49ucD filepath-1.4.2.2
    githash-0.1.6.3-IMCqyQBXyhT9s4ql3Y4nh8
    hjsmin-0.2.1-9LbyWfOBKrS9NNYZKJiZ3C
    hledger-1.42.2-3tpkm0nogRF27dw7jZrU1X
    hledger-lib-1.42.2-4Ja1910WJOFACFifZXllvC
    hspec-2.11.3-BOHW1A2gcxo3KhBOKeiaIX
    http-client-0.7.19-uUUIOTRb562pkjpXBVB7U
    http-conduit-2.3.9.1-Ett5GXtAkZH5bqOT2HIt8b
    http-types-0.12.4-7tROZjbzWJo2UxJQcRSyTt
    megaparsec-9.7.0-h6TIpk0ovfDneD2rtVfdC mtl-2.2.2
    network-3.1.4.0-9ttathdcL583NH2Tw8H5yc
    safe-0.3.21-18jAQK8jji87dfRYhZ3RVp
    shakespeare-2.1.4-BLdxEcNRfwn1akFznNvLrs template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-CYGJOM1K0tFLPsAESFm1Qp
    unordered-containers-0.2.20-9npXt9Xm1lq5WoODUfmSXc
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-503EmWLO5Iw5DbOyOWIoyF
    wai-cors-0.2.7-G6MizrAwoxT99wgF4OgUdn
    wai-extra-3.1.18-7SlzrCDJkv0C1vRsQSUDcN
    wai-handler-launch-3.0.3.1-B2HvjzRVsW93EDeRf1hLEX
    warp-3.3.31-AlPgaLf7sPr6DlgMvfrYcu
    yaml-0.11.11.2-JCoArX6f32N83yvd9RQfTl
    yesod-1.6.2.1-D72oyLd4eGaKDcpOmpY8Pz
    yesod-core-1.6.27.1-HZ6O8hjLeel1HzsTkR4Mho
    yesod-form-1.7.9-DG332l6PkVQ7jbwlLALb2t
    yesod-static-1.6.1.0-DWrPf72IZWq2XmO7vcKAM9
    yesod-test-1.6.23-73aljHillutA7mxRZ9nsCi

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

