#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.42.1
visibility:           public
id:                   hledger-web-1.42.1-Ihhy3tLms9H30HaQCrS026
key:                  hledger-web-1.42.1-Ihhy3tLms9H30HaQCrS026
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  b205920326cc7e042454433613465536
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.42.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.42.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.42.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.42.1-Ihhy3tLms9H30HaQCrS026
depends:
    Decimal-0.5.2-JJnAxbNB1tGBgDhgIz1FwP
    aeson-2.1.2.1-nTcMAwSjFOFbKrX5mWkol base-4.17.2.1
    base-compat-0.14.0-D6ySGt5shRqHRPQXrHl9Oo
    base64-1.0-Guq2gD4JAR23vn8iGR7l01
    blaze-html-0.9.2.0-7ZP6TBGCXvM5msBno7uCel
    blaze-markup-0.8.3.0-9mvKITBBxoCAOVptmmL5Cl bytestring-0.11.5.3
    case-insensitive-1.2.1.0-Dv0qc5eM6SdL4nJsx4bnK
    clientsession-0.9.3.0-CMi8i3IWGbGBUiGtcnff7c
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-GPe8u3RYhCEKxuB1doj8qM
    conduit-extra-1.3.8-H0Ux7lWGa6s1NvcyXyCw5o containers-0.6.7
    data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd directory-1.3.7.1
    extra-1.7.16-74Y9X6JFoGGAtiav1DDKW7 filepath-1.4.2.2
    githash-0.1.6.3-1j6aIIUg6lIDTgLjlwqL8
    hjsmin-0.2.1-IHRKqJnu8tRB42wbTpczT8
    hledger-1.42.1-FrjxBZoOPIrDA1kAvdmCZ9
    hledger-lib-1.42.1-BoPBl91aBElEB6PCzAFH4P
    hspec-2.11.2-EAjc0FWNx7lAkrkEnSI1Wl
    http-client-0.7.19-ItVvZ8PodQhKrjwqBcCUYZ
    http-conduit-2.3.9.1-9M6db8NxYC6F60kH7ZDB5l
    http-types-0.12.4-1OQw2FrAjtsGCePB2Q8s8s
    megaparsec-9.7.0-30CmWzNYqun9hcXpVgYg36 mtl-2.2.2
    network-3.1.4.0-9SQkdFTpEbMLQxc4pkijnN
    safe-0.3.21-JtmveFmtp7AKwHntYKRiun
    shakespeare-2.1.4-A1Hf81MWlINK8fFkSg654L template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-8OQzyIScvCNZH5Kpr8RxD
    unordered-containers-0.2.20-KDi8IgRcOV5HCm7hBAqDWV
    utf8-string-1.0.2-JqS4SAQdze6LQzXf6ug2xB
    wai-3.2.4-F2VJAE8OhtyI4jBCcdCBBc
    wai-cors-0.2.7-HVYfud8TfdM4olvwWlro7Y
    wai-extra-3.1.18-A8mI1ZW6fiMCkT3EnkiIQn
    wai-handler-launch-3.0.3.1-4qBGZc5j0pn6FmVH7YQqa7
    warp-3.3.31-2xKr7NKtFfPIy8QpWTlEw2
    yaml-0.11.11.2-xXqumrqEt97lCR90JobaD
    yesod-1.6.2.1-D5Kc0rUHxI5cXYjs6amCc
    yesod-core-1.6.27.1-4glhYkVlnHrLbvKCxkiBHz
    yesod-form-1.7.9-9klFpx3aPNJDeTbASZwaAP
    yesod-static-1.6.1.0-C3LAvBud5Af4ldZUzR76TL
    yesod-test-1.6.23-33WNcZKGDl67NjNsZTzHei

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

