#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.42.1
visibility:           public
id:                   hledger-web-1.42.1-7KwD8Hbu6te8Vl8OD0TLvd
key:                  hledger-web-1.42.1-7KwD8Hbu6te8Vl8OD0TLvd
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  e1fd46b1e0add550f75525495c674b27
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.42.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.42.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.42.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.42.1-7KwD8Hbu6te8Vl8OD0TLvd
depends:
    Decimal-0.5.2-LMKo4ChlKtKGTJQoPteyo1
    aeson-2.1.2.1-7VTFzNaeQhH4xougawMBap base-4.17.2.1
    base-compat-0.14.0-D6ySGt5shRqHRPQXrHl9Oo
    base64-1.0-HCd4N4HGSTR3ghB8sAevi7
    blaze-html-0.9.2.0-IDybBwOqjaeDYYIVGdUmMh
    blaze-markup-0.8.3.0-BiOu39W6ZqkIuEgphwproy bytestring-0.11.5.3
    case-insensitive-1.2.1.0-4P9iCjJMWMIHxNOvyaASZG
    clientsession-0.9.3.0-3nzHcccxU6eHUWtGhmyuNu
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-793fWFbadkvFwVYySs1ukE
    conduit-extra-1.3.8-J293Gy7jkA85zCTXiiBmMK containers-0.6.7
    data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd directory-1.3.7.1
    extra-1.7.16-1cKp5Cy9JHKKmY0j3a7DvM filepath-1.4.2.2
    githash-0.1.6.3-36Aq78FnI4hBRzdivp7CVL
    hjsmin-0.2.1-Kv4nXh3iSvN8yhZe3TbCT1
    hledger-1.42.1-JZ0076ZRbzLDSgxX4QlgRJ
    hledger-lib-1.42.1-E4d6tfZGLXLJ6Fc2tqvo6I
    hspec-2.11.1-LYM0tW60Bg1Fw9LJtyOuZx
    http-client-0.7.19-sF7xCO9vzdEEZgZxhmYN0
    http-conduit-2.3.9.1-5kjpxT7co1yHfoGbZW52Ph
    http-types-0.12.4-3DQiCH8RwXkLA2zexb7ibB
    megaparsec-9.7.0-EiOytuystFBC1v5RoiaLHB mtl-2.2.2
    network-3.1.4.0-9G0x2c0R6cS5Adtb7MLWUj
    safe-0.3.21-EvJ6Ca7ZgFx49PYHKYQDLu
    shakespeare-2.1.4-Dz2Hsyah49KEifXrVULqaL template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-9zHJnmH6dkzJQafueuILIm
    unordered-containers-0.2.20-Iia3zhz8DVL3Efh3E6ja96
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-7gPy4vrA6McEXoAULdTry7
    wai-cors-0.2.7-Ieobycre1ca3E8RweOFVWM
    wai-extra-3.1.18-2SLQ20ZlWOTEyHLpicnMTC
    wai-handler-launch-3.0.3.1-5axkD36QIie3CuNOFkYpMu
    warp-3.3.31-BWp9L2zAoW4JruynxSXs04
    yaml-0.11.11.2-H1nuXEEMOoiJmZB9LXY3X9
    yesod-1.6.2.1-7KwnHzcayvkHOp9MhwjRU9
    yesod-core-1.6.27.1-5wpbNar1YRPL4LYUQcYFNh
    yesod-form-1.7.9-Ka7uTXi9YkR5DxuEE6XpCV
    yesod-static-1.6.1.0-2bxpJizK84fIi2tmK36agW
    yesod-test-1.6.23-B8CtrPhTqQRAAugNoeUOPz

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

