#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.42
visibility:           public
id:                   hledger-web-1.42-CsGIsxpSq24G70W5nKegBB
key:                  hledger-web-1.42-CsGIsxpSq24G70W5nKegBB
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  6724b46f4e7e805299fea3f979ecd1e3
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.42
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.42
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.42
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.42-CsGIsxpSq24G70W5nKegBB
depends:
    Decimal-0.5.2-2AYELZshEreE5LLFr0KqOX
    aeson-2.1.2.1-7cfkxE9Bq2x7khGuVuQDC7 base-4.17.2.1
    base-compat-0.14.0-D6ySGt5shRqHRPQXrHl9Oo
    base64-1.0-Ix0VswNVmHT6U6EPDur4AH
    blaze-html-0.9.2.0-FdgXo84MQ5nJDnaCr5A0hJ
    blaze-markup-0.8.3.0-FTbVLvi8ymwA66L8hkAPCp bytestring-0.11.5.3
    case-insensitive-1.2.1.0-GQeAlR2AZ5qKSa6EskqV7j
    clientsession-0.9.3.0-7VXogiDEYqgHYwjKK0JXxH
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-RIPQH88pa6HdGnxqZVAxX
    conduit-extra-1.3.8-Wf90Wdd777ELFlunPZvQx containers-0.6.7
    data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd directory-1.3.7.1
    extra-1.7.16-GPFGXPy3lHS8GfXyw60437 filepath-1.4.2.2
    githash-0.1.6.3-1hoZ1N54R1YEUQg1FoJP5
    hjsmin-0.2.1-6zbLiM156OBGb6N1n0cjJI
    hledger-1.42-JsuTQWYl4y746hAKTthSXc
    hledger-lib-1.42-5URHa1RkJNBEyuG0hrvpVy
    hspec-2.11.1-51L8eQASpDtEQQVHo7pO94
    http-client-0.7.19-JmHmaoQUy1C5oiPZXr15YF
    http-conduit-2.3.9.1-36cvg6VCtE14rRNMl56unc
    http-types-0.12.4-1rtZtKDzV5obVFgF5aFTX
    megaparsec-9.7.0-1c2jPx0UmJAAFouxjMyF3D mtl-2.2.2
    network-3.1.4.0-GdpHxCm9XS6F665gL00mHk
    safe-0.3.21-G3XWHHk4zW66NY70hs9fn5
    shakespeare-2.1.4-Cg5DyVSUPDWArfkdE7Anml template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-K3sPpbojWsd9DZaxM69rAR
    unordered-containers-0.2.20-7E9U8fDCyyE7V5F5vC663n
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-8esVLXywzhH5CPpOFjxVlw
    wai-cors-0.2.7-L9mxBS0BmyDL0TA4qmVlDz
    wai-extra-3.1.18-FAjQJKzopf826jCtGU97E2
    wai-handler-launch-3.0.3.1-AJKE1mUEwWl6bd38rqTNkI
    warp-3.3.31-8lNbNvFc0wV2wm0UGkm1dD
    yaml-0.11.11.2-JpjP7FdNwXQCpp7s8FAnSW
    yesod-1.6.2.1-76wPZCYabTqBYDKZvJTdV6
    yesod-core-1.6.27.1-5oRNxTwFP9a1rPMQTl4Xq8
    yesod-form-1.7.9-3JZnDAquyUcK24AhpLip2a
    yesod-static-1.6.1.0-wnmSIcD3uoFsIBeF52frQ
    yesod-test-1.6.23-7aHsJJMxAMNJaUseeFHx0n

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

