#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.42
visibility:           public
id:                   hledger-web-1.42-K40OsB6Dke5KTRmXicHQOV
key:                  hledger-web-1.42-K40OsB6Dke5KTRmXicHQOV
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  9aadc9ad9b685ff272adcc0772ace9bf
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.42
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.42
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.42
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.42-K40OsB6Dke5KTRmXicHQOV
depends:
    Decimal-0.5.2-ve1gQUeDi720IdCvxcZwJ
    aeson-2.1.2.1-IUt8ms8F4mK1p5ihNOaPfT base-4.17.2.1
    base-compat-0.14.0-D6ySGt5shRqHRPQXrHl9Oo
    base64-1.0-3Puf7FdHCKg5sktkBVDs2S
    blaze-html-0.9.2.0-Irz9BEYJh8t6ttuT8sjDNM
    blaze-markup-0.8.3.0-vIyaH4vY5i1DL0t3Gsy7s bytestring-0.11.5.3
    case-insensitive-1.2.1.0-EZuETxE1IO9HODmjZlC6xu
    clientsession-0.9.3.0-Jk67ZOYnTG73wer38QWnO5
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-1PwUZeKQSSaAIlloD0uxVY
    conduit-extra-1.3.8-4NFCStHKh9n4s3SuL5Ir9b containers-0.6.7
    data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd directory-1.3.7.1
    extra-1.7.16-2947RCqGIqYFOyB1jx0D04 filepath-1.4.2.2
    githash-0.1.6.3-B0dUCoK53b5JeMVhe3ZZZz
    hjsmin-0.2.1-6BVaBTqBBWGIyWnAbr8CJU
    hledger-1.42-B7O59N04gDM85mLUB7AuCu
    hledger-lib-1.42-Dautn2bHbli9iH9snLuvU0
    hspec-2.11.1-BRHfP2HaLEfBtTR5o9oGhY
    http-client-0.7.19-7srnVyNI4Ze55d0gN5jz45
    http-conduit-2.3.9.1-BiJe1XkI0y2KbIzKrVWbPm
    http-types-0.12.4-8dp7TKfAiJvJDE5Kav0jk0
    megaparsec-9.7.0-JCsirEhLFw2GjFGhRNZw9x mtl-2.2.2
    network-3.1.4.0-3FUQiZBqCiD6JAPkelGiT0
    safe-0.3.21-JSgKJ1qQ11UGSifs2bSHTA
    shakespeare-2.1.4-2RnPuW09BnpI5HoZKWSnah template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-KTySjwALiEB80HjBcqozOs
    unordered-containers-0.2.20-8z8yrOH3Dwd8Gc78vZRE2k
    utf8-string-1.0.2-6nfZpgw1Ffy3MDnMPT0XX9
    wai-3.2.4-94AIQdArDsBJuJKIXDdJBx
    wai-cors-0.2.7-32aoyQQ2XY16vvldbCh62h
    wai-extra-3.1.18-A7p0ii28XJXLevHog476Fc
    wai-handler-launch-3.0.3.1-IQmM4VqnKKgGSakhEieRnN
    warp-3.3.31-JYKRwmEU2qg7pazB9v4eTW
    yaml-0.11.11.2-31hmY8yatXJDt4GSriZBBL
    yesod-1.6.2.1-568fXVDvzDqGa1QvetdmQb
    yesod-core-1.6.27.1-Ie4auOXj9qOD6Ahbznl4fN
    yesod-form-1.7.9-24dqa5PrVqb50D9m5A38r5
    yesod-static-1.6.1.0-8yLWU7zeJ9t5IGcQbRIilG
    yesod-test-1.6.23-IWx7n1InaV5OGsWojYGvI

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

