#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.41
visibility:           public
id:                   hledger-web-1.41-FW6Y6XIDAxoEAaQQR3HgKh
key:                  hledger-web-1.41-FW6Y6XIDAxoEAaQQR3HgKh
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  df241040410b1c55a1f3b33c5bdeb184
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.41
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.41
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.41
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.41-FW6Y6XIDAxoEAaQQR3HgKh
depends:
    Decimal-0.5.2-IWeaesuqq6gGvo8Ig64LdE
    aeson-2.1.2.1-4RB85zdNr5p3whZ1np3a31 base-4.17.2.1
    base-compat-0.14.0-D6ySGt5shRqHRPQXrHl9Oo
    base64-1.0-D6Efe39PGSe9bQlZXJr9nq
    blaze-html-0.9.2.0-Cv5u1eWpWkgLQ3EG0vDZlF
    blaze-markup-0.8.3.0-CsF5JFEey9Z78NugLbJTVe bytestring-0.11.5.3
    case-insensitive-1.2.1.0-LYFsGNYxHzcJNUKypl8Xr7
    clientsession-0.9.3.0-AlOHPH3Cap5I0JfHe3wWcJ
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-8yY1jDXBMRk90iKvTAknJ8
    conduit-extra-1.3.8-20yj5GJQbJrGq11c4ONfrP containers-0.6.7
    data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd directory-1.3.7.1
    extra-1.7.16-KGJm7HE8TMo8c4jTE4Z3yy filepath-1.4.2.2
    githash-0.1.6.3-7Zddx0w8sxlBZCCQmjKySz
    hjsmin-0.2.1-8j8bQNvfTNAFkCfrFBnPiz
    hledger-1.41-BWC1CEcIisXIVbvW2A0ich
    hledger-lib-1.41-FrwV87zNqMYHm58d5Ibptv
    hspec-2.11.1-GaBAeHlVc2ILTCU5OQF0sK
    http-client-0.7.19-BlnOOoYFAm21qMqpEBWgqP
    http-conduit-2.3.9.1-4gxxgZUedcOIrtFfJ1nJK0
    http-types-0.12.4-Jx04LytKDQxAS6dwQTH9Cw
    megaparsec-9.7.0-820EiikhmYYJfbjX1fu2Y5 mtl-2.2.2
    network-3.1.4.0-KCu1LDB4kGQHeeCsiSLoOZ
    safe-0.3.21-DKOKWo9pals8WHvcv2YlI8
    shakespeare-2.1.4-6W994xTQ8VLK5GedtaogvE template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-AZ3QvicZDsfFka2eKBF0EH
    unordered-containers-0.2.20-L410VxfvorQ5RMb8wocThG
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-HB9yxc5cWSY3PjQANbUXrV
    wai-cors-0.2.7-BlE3AcTFdbgAlSW54A6BER
    wai-extra-3.1.18-HGqKFbiDRfyJOYUe4j6hWW
    wai-handler-launch-3.0.3.1-nqiKhayN4jFKoHOteuy36
    warp-3.3.30-6NKX59beJQBK1qUf1zNclk
    yaml-0.11.11.2-1rOXYhv7h9B3GT9PBryEjl
    yesod-1.6.2.1-JpyIqgoPezS5c23Lrwz0SL
    yesod-core-1.6.27.1-DINPwOgXWs9JdnmcrgPXMG
    yesod-form-1.7.9-6BrhKwdqR6Z9KvwwW0YvsN
    yesod-static-1.6.1.0-IcVva2ECRHsGTXT8U8g4TD
    yesod-test-1.6.23-vW7nriF17qFAhh5rz8g8t

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

