#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.41
visibility:           public
id:                   hledger-web-1.41-73DijuOscY0JCoun1Y8zKr
key:                  hledger-web-1.41-73DijuOscY0JCoun1Y8zKr
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  7ab3c7b4e9aaa766186c25ddaffef8f1
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.41
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.41
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.41
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.41-73DijuOscY0JCoun1Y8zKr
depends:
    Decimal-0.5.2-3XSz0Ycoi41ChBCXCqK5r0
    aeson-2.1.2.1-30WJrKK1Pbc1pP0H7Lz8HG base-4.17.2.1
    base-compat-0.14.0-D6ySGt5shRqHRPQXrHl9Oo
    base64-1.0-JyEmkfWGkwm9L5GW8NJ0nz
    blaze-html-0.9.2.0-D6khwrbejGRHAmMP2tGf4Z
    blaze-markup-0.8.3.0-EbqyAfAeVhuGBAyeBNN81V bytestring-0.11.5.3
    case-insensitive-1.2.1.0-3u1lhibUOI39diOsp8dwhN
    clientsession-0.9.3.0-IMCPbVXSGIcAXvBTBqNYp9
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-L9TggbIlNiTCDF5rGZVa9g
    conduit-extra-1.3.8-19lmWL4nfT7KBh5mbFf6Y1 containers-0.6.7
    data-default-0.7.1.2-2qohbnSvS9oK93FFGOJ5gM directory-1.3.7.1
    extra-1.7.16-Bd5z33Uz6vY4Zv52jbXbiv filepath-1.4.2.2
    githash-0.1.6.3-73OT432U0FNHsu8vVH3XUr
    hjsmin-0.2.1-EreoTOhSiv39rOzi5cuVvD
    hledger-1.41-B0SNXxp0esb3e52jTGGARZ
    hledger-lib-1.41-C31USiRgZOY3sxLLAuHkyN
    hspec-2.11.1-CD1Vln1DaKx9WxGfSOhHmR
    http-client-0.7.19-E75obOxKY6lFjozf9B0Cdj
    http-conduit-2.3.9.1-LgOKwVemqZ11w6ESfzKP2k
    http-types-0.12.4-HAGemqHxPpJ61NPMOsJY37
    megaparsec-9.7.0-3uOOds7dkmdKa9eAfy4ha7 mtl-2.2.2
    network-3.1.4.0-1eoJcyQnoY08famP5jSKP3
    safe-0.3.21-Kkw0osvJ6bGGcKGjvVXiul
    shakespeare-2.1.4-F2NAfHdShpO7Fwb05vcS1Z template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-GRcWteAUk7yFBTumPQtTNN
    unordered-containers-0.2.20-JDDg5JU7nYP5ffg7vR2UZh
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-35VOG5Vf7yXFyy7nrz2acQ
    wai-cors-0.2.7-2griqhSiEafFS7VSmWAECL
    wai-extra-3.1.18-HlqHrdQso8z7Wm60bU53Wo
    wai-handler-launch-3.0.3.1-7ae2noyxsj3LJMkzpSHmhv
    warp-3.3.30-6Z9eNkEsJzZ2YILrOaNZWf
    yaml-0.11.11.2-6SCxejT0KnR2BgWlQyY0Sy
    yesod-1.6.2.1-3MKDkIrRrX7KAOlPaAjt2U
    yesod-core-1.6.27.1-5kAmD32neFQ14NDvT0543d
    yesod-form-1.7.9-2YIIk2yYWmIFwc8iX45ker
    yesod-static-1.6.1.0-2pLXH6xPPUcKDAibN5AdQ0
    yesod-test-1.6.23-EoMPFwhvxk9ALjD1DsFKSD

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

