#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.41
visibility:           public
id:                   hledger-web-1.41-EZR5kmxxgl92H4IN6HEydZ
key:                  hledger-web-1.41-EZR5kmxxgl92H4IN6HEydZ
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  1c32e42044093c9bb0a5cd4beca42964
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.41
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.41
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.41
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.41-EZR5kmxxgl92H4IN6HEydZ
depends:
    Decimal-0.5.2-Hia0mmQucZx6aJcdpX4shm
    aeson-2.1.2.1-CoFGCad0PesDH4XC5ctCv4 base-4.17.2.1
    base-compat-0.14.0-D6ySGt5shRqHRPQXrHl9Oo
    base64-1.0-3CjasWjXAMY41Z2NuNuk95
    blaze-html-0.9.2.0-5UHR2rFfuO85rrjBAwZQF8
    blaze-markup-0.8.3.0-Hf0qvHn7apcGFSqpkksMWB bytestring-0.11.5.3
    case-insensitive-1.2.1.0-761P1jvxXU26pNc4Eb30SJ
    clientsession-0.9.3.0-LFTQafdiB4p8oEmnvtr58j
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-LX1OqlTDVgXB5T9goEDWxI
    conduit-extra-1.3.8-DMXEhav2zajAIstf73Tomd containers-0.6.7
    data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd directory-1.3.7.1
    extra-1.7.16-78p7g4t2O5F2wUG9XuP5u filepath-1.4.2.2
    githash-0.1.6.3-JnZcl9YizUQL2SdpRlL7Gp
    hjsmin-0.2.1-64ehGjaKjSk2oQ7TM4L7Mr
    hledger-1.41-8ratf840WOF5ry2z2LoYNX
    hledger-lib-1.41-ExAuO7uzvPnF2aceiPBu6a
    hspec-2.11.1-8Bmj0jriNwhJpDt5d3xUJM
    http-client-0.7.19-IIytK7PBQn9EsqIfUwIiV
    http-conduit-2.3.9.1-9Uv6XpRhxDvK3s54aNa7vF
    http-types-0.12.4-BqXeLjMsy2zE8Q8bHBFhrt
    megaparsec-9.7.0-3LvenIwsMr98PPayp8iMYY mtl-2.2.2
    network-3.1.4.0-K2TPJT2eLM87X4awxEjMbA
    safe-0.3.21-ByjvVtJLwt5KrRntZowDKh
    shakespeare-2.1.4-7yFJoVoeer96i5ax8Hh4Zx template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-7mIDBr1TancFwsGNESA8LC
    unordered-containers-0.2.20-9wNMaDmysQKAAHkxxaXhUB
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-CKkA8Aq5NeD7z1ZAcTjQU2
    wai-cors-0.2.7-2JyU87X2T3n2cpb6MUI29L
    wai-extra-3.1.18-3PzoRgjiECxaGbtLxhRZ0
    wai-handler-launch-3.0.3.1-4GCZzpAYcRVBB8Jzq3Ruep
    warp-3.3.31-5Upt4FlcfUMEp32SVP0hA7
    yaml-0.11.11.2-DOTRoIN69iI8VkvsxHJhD8
    yesod-1.6.2.1-CCjOtqfQ75RWnDMfrF7Jd
    yesod-core-1.6.27.1-AATcviqIZ5x7loyuqwCxSV
    yesod-form-1.7.9-JsEENxlSmL8CL7SsShJ69d
    yesod-static-1.6.1.0-BJviIQPdtq7IHVUWpKJ69K
    yesod-test-1.6.23-LpHDt2jnsh93g4p2tTB1R7

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

