#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.40
visibility:           public
id:                   hledger-web-1.40-1sRbLk1EcFc3t3pvPRf8v3
key:                  hledger-web-1.40-1sRbLk1EcFc3t3pvPRf8v3
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  d97a641cec98727cefc0294e81ce7e42
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.40-1sRbLk1EcFc3t3pvPRf8v3
depends:
    Decimal-0.5.2-9MFIBXeyIJJLdqol8CveNZ
    aeson-2.1.2.1-IZ8jLcnEISD7S5Vyf2Tehm base-4.17.2.1
    base64-1.0-Kt3QwP4JmSgHlYnVzN4OGw
    blaze-html-0.9.2.0-LTAcRvwA4RX5X1Di6KFyT1
    blaze-markup-0.8.3.0-GZv1FLpSykS3DHygI81NMN bytestring-0.11.5.3
    case-insensitive-1.2.1.0-3FuXchFPXBfLVJKu7fam1O
    clientsession-0.9.3.0-DwbGSiWUr63E1GcKDLEGef
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-6EN3TiAZvJYIfvMY9NMvKR
    conduit-extra-1.3.8-ocqV3ZQIM7JZjciPRh2Zy containers-0.6.7
    data-default-0.7.1.2-2qohbnSvS9oK93FFGOJ5gM directory-1.3.7.1
    extra-1.7.16-84Gt3POgtfP5cuz093nHzi filepath-1.4.2.2
    githash-0.1.6.3-1M1Z10SoNv274JsnwQKUT3
    hjsmin-0.2.1-KhsSYY8fmP2DVclUEERvij
    hledger-1.40-Kh0Ubm9bAjPIUXfPwADVg3
    hledger-lib-1.40-KXxN6wAg4KG55LW1YG1dGX
    hspec-2.11.1-IdJoh4JqLqi36U3zxarxk3
    http-client-0.7.19-B8l1xqF9CzrAQJibWsxIAb
    http-conduit-2.3.9.1-3unIqyPQbILE7LHBwWMmkF
    http-types-0.12.4-9GhteoJuOlZ3ATAYoIbhkU
    megaparsec-9.7.0-EujlCtvd6hmm53pqN4SFa mtl-2.2.2
    network-3.1.4.0-KAEk2uZxmO9GA8hoXz0jL7
    safe-0.3.21-KEfOvx15i1f7ewOxq0ZYoN
    shakespeare-2.1.4-CqqdfXGNZiD7D7HpP7arnf template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-FHEkyK2HAgOIviNihEwrGS
    unordered-containers-0.2.20-79maJZZuZDu8bRI1CHuoJG
    utf8-string-1.0.2-EpYvbnx7dwVHTduFVbgaKq
    wai-3.2.4-LSet4Oo8Svc8BhPeth6Bg
    wai-cors-0.2.7-6sJ9NG6FxSf39GGBez1izz
    wai-extra-3.1.17-LNZKSRSoPdF14IlWcRuLur
    wai-handler-launch-3.0.3.1-9LLmKRtnqy3GQBZv9qCM3A
    warp-3.3.30-JYRa6G4TpFBCfP4ZSgWbtY
    yaml-0.11.11.2-1K4UmsabMqiEDmJhHUW5y4
    yesod-1.6.2.1-6Imi4RW2SqHGbr13iZwhHW
    yesod-core-1.6.27.1-Jb6fPjsFJ96FJVGXRQTljw
    yesod-form-1.7.9-FH9VVRgfjLi1JTsUx6eVrd
    yesod-static-1.6.1.0-BrMRGoxSClf9Fz4fma5EhM
    yesod-test-1.6.23-CBOJEKfUER6FMWhQdOUuVV

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

