#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.40
visibility:           public
id:                   hledger-web-1.40-284Aw4KKUrt8hmyJNC6LxS
key:                  hledger-web-1.40-284Aw4KKUrt8hmyJNC6LxS
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  caf5e9d7fba2e3e3b90befc4ede61a25
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.40-284Aw4KKUrt8hmyJNC6LxS
depends:
    Decimal-0.5.2-2CgyFe8EZ1Z9PnfiQRcyVh
    aeson-2.1.2.1-F8ZePgr6g4xL6kF4wsQx0x base-4.17.2.1
    base64-1.0-AOBYjFWbkaNC3XCuxhktDT
    blaze-html-0.9.2.0-Hmx0qDwpXdTINSADNpvYjl
    blaze-markup-0.8.3.0-3B7X73TXz7h4xBgQnwPnu3 bytestring-0.11.5.3
    case-insensitive-1.2.1.0-B227KtiOix4GTDgvxk3FBB
    clientsession-0.9.3.0-3C3j9ewjhwYJHRqISsHube
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-Iv674JaqEE17PR7slCoUfp
    conduit-extra-1.3.8-9BT5gTgmegiEww1RLwnr5K containers-0.6.7
    data-default-0.7.1.2-2qohbnSvS9oK93FFGOJ5gM directory-1.3.7.1
    extra-1.7.16-DH9VMRj2B4M59QQF4Jl9K7 filepath-1.4.2.2
    githash-0.1.6.3-HXowrpvsd4q3HFgS4Tfvpe
    hjsmin-0.2.1-3BZX3AB2yCWKZou7qGKdMV
    hledger-1.40-LG5Y1diMZQZ3Vls8d548lc
    hledger-lib-1.40-CgAzynLJSkI5XofyR22fKg
    hspec-2.11.1-GIH8vH53bMNE8dUYSTqrgH
    http-client-0.7.19-LRfftiQ6YWX88xW4fFXEK8
    http-conduit-2.3.9.1-CPmopMKYDZmGtVTs3jcq5H
    http-types-0.12.4-Hsb6Y5xUgLKEUlBrgYk3WM
    megaparsec-9.7.0-7jzSygYb9UCHSxVBa30IvK mtl-2.2.2
    network-3.1.4.0-7GxbLibXQB6BN49yptQL65
    safe-0.3.21-6M2s73s6VIBE0aNh1wWxu0
    shakespeare-2.1.4-4tAwPvnVRQf3cGkcgceG99 template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-51QWcgHKY9Q2M4gdNfLh1f
    unordered-containers-0.2.20-I3GOf8berWn8tol6ImoSEe
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-4xRq7ogBaZ8Gldz3i6sILu
    wai-cors-0.2.7-F8VdQYTSkofSbAOBRo2E2
    wai-extra-3.1.17-8YgjU15N6oKKg25qYeS49N
    wai-handler-launch-3.0.3.1-EgfNop2d4FHIR41eToSxmQ
    warp-3.3.30-AhKrB9wwsoN3qw8940l6Mi
    yaml-0.11.11.2-4MoiGONAAOECgm0j0bgnYj
    yesod-1.6.2.1-KWZTTsgc2v67lvykS6EqAH
    yesod-core-1.6.27.1-I8FGdNiQZmJFE7eJz8jJVg
    yesod-form-1.7.9-v5B5Gwjs5H8ujXxbiDdi
    yesod-static-1.6.1.0-9uHYCBLsS9TJklRTjsj2dC
    yesod-test-1.6.23-5MR8FfrFXT8307TCgBz02U

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

