#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.40
visibility:           public
id:                   hledger-web-1.40-KYCQ19yvNHCAwgnajE80m2
key:                  hledger-web-1.40-KYCQ19yvNHCAwgnajE80m2
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  619f3e70d72bd72275f652b2160dd1d0
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.40-KYCQ19yvNHCAwgnajE80m2
depends:
    Decimal-0.5.2-JMHj3AizehAAFz9vPsqwCm
    aeson-2.1.2.1-CM1TyKExMgH6p2KQqrdDHD base-4.17.2.1
    base64-1.0-HY4F2glCSN9C0t9iFN7zhY
    blaze-html-0.9.2.0-GSQGyEfgR96HA14H2zM96E
    blaze-markup-0.8.3.0-L6t6v2gy37n7wxr3axaBPf bytestring-0.11.5.3
    case-insensitive-1.2.1.0-9KyZd02Y5otGRG4cekIJFk
    clientsession-0.9.3.0-LIoSSjqXUZnFTz1WDjSSmU
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-P2VVzWMvOMICi7Nj7BTmx
    conduit-extra-1.3.8-4zxXchcBeveL56hfIzolRA containers-0.6.7
    data-default-0.7.1.2-434WfftxN7fJEVVCTZ9w4g directory-1.3.7.1
    extra-1.7.16-DwxSHwEmcgPLc5aa6ovQbP filepath-1.4.2.2
    githash-0.1.6.3-xIo5s05ZIrBS96H2hB4CI
    hjsmin-0.2.1-G9OtDuugN4sFUi1HtwkCxW
    hledger-1.40-EpbtlLL49AK4W9CNWzBwFd
    hledger-lib-1.40-DqqywEScuaQBsv1xoudKz2
    hspec-2.11.0.1-4PhyYxVsZ9BERANewCnqCG
    http-client-0.7.19-9qUcwTVQqbvEShQpYcde6b
    http-conduit-2.3.9.1-9RvHGJGxwHHJpUO7Zqiogv
    http-types-0.12.4-9tb655S6p8NAIcFLCK3aeD
    megaparsec-9.7.0-3LaPBNRfEWMD5TdaoQ3jm0 mtl-2.2.2
    network-3.1.4.0-BeHm9PhAGW35QMcXomVSuT
    safe-0.3.21-2QfDol6D5mJHd9hpTIyjO0
    shakespeare-2.1.4-Iedb7wnv0QZDrYJoNNfJhF template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-8Y7lpXTSloK7vqVswTol3
    unordered-containers-0.2.20-FLM1pZb3BI5FpyNo5sVXNv
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-3rYyRDQ9fFM4U5H5e4fgc9
    wai-cors-0.2.7-9gtFnXcUPQMEas1FEQ3lY8
    wai-extra-3.1.17-5wguenEtMHG266p7AZdQP3
    wai-handler-launch-3.0.3.1-BXfvjXHQeBz5nxRh4byrk8
    warp-3.3.30-HPCf6dkLAlC8bCsy9YDsw
    yaml-0.11.11.2-4AgLdlJHbVGhCUrAMC0TD
    yesod-1.6.2.1-3NW3ZcQ2n4PClv2U7O0AGq
    yesod-core-1.6.27.1-ECql3enXKylA3J8a9QeZ0L
    yesod-form-1.7.9-LXRLg2thegAGdyMPVCEJnE
    yesod-static-1.6.1.0-7aWSSDruxFAJVt7vp2UkmU
    yesod-test-1.6.23-6eMh4Hns3XrXmITVRjXI0

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

