#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.40
visibility:           public
id:                   hledger-web-1.40-2wGPg6OFObYK65gYAMcydl
key:                  hledger-web-1.40-2wGPg6OFObYK65gYAMcydl
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  da134ee034d25f8c275f085bbb0c093d
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.40-2wGPg6OFObYK65gYAMcydl
depends:
    Decimal-0.5.2-GiUEyuZvGbG7NmVGLQ17Ub
    aeson-2.1.2.1-LvJWrHbVhNW5j5NGQeCpIT base-4.17.2.1
    base64-1.0-2oAdDEcLdPeICw8UcjFziX
    blaze-html-0.9.2.0-97pJC8dBTXf5qZAc9J115X
    blaze-markup-0.8.3.0-FXydca45yHzIHzHIuN3fo7 bytestring-0.11.5.3
    case-insensitive-1.2.1.0-3W7hj1sdmUw2Fh1p1ue6cC
    clientsession-0.9.3.0-D7WhPIttJhDDNg8EWkTcFV
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-7gDrgQT36z4IN6MqKXM4jU
    conduit-extra-1.3.8-LH0nSmNEDBz6QpPwrMyaiE containers-0.6.7
    data-default-0.7.1.2-2qohbnSvS9oK93FFGOJ5gM directory-1.3.7.1
    extra-1.7.16-4bj2qzOh6Wy7BUXQcjUwOi filepath-1.4.2.2
    githash-0.1.6.3-GPKiuWIGGGu8BJaENQYPrA
    hjsmin-0.2.1-K3xARjGHdk29ItSsTcL3lF
    hledger-1.40-7Qusj5El79GHKfCE0JVgN2
    hledger-lib-1.40-9uv8v9UHDb9CfpBDbn89RM
    hspec-2.11.0.1-BUjOTFy6tZ3ImH4RQIz6MO
    http-client-0.7.19-FAI99Ioi5R36WLiLxr7VX7
    http-conduit-2.3.9.1-6m79Y0ZNJvKK9qOtarTSOn
    http-types-0.12.4-Lh5dVrkMNHmKdCH2kircer
    megaparsec-9.7.0-3kDa2AKG8BH1ETde5AtQpM mtl-2.2.2
    network-3.1.4.0-FZePtqluqyjFxAKIHdZ8Kd
    safe-0.3.21-5ePY1yCKz45qNPHFPlOcS
    shakespeare-2.1.4-FvR6d31LrzNFMKbyxb17B0 template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-7oQJi6rZtGSLEqBNRXK8Qv
    unordered-containers-0.2.20-Kt9XOM1GYdv4KClqugAe9a
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-FetgZkW1yF462S5B7261uz
    wai-cors-0.2.7-4VHQVm2OJ4NDQgkgYoT22y
    wai-extra-3.1.17-KKZMoiquzOn1YwjEb4PCwP
    wai-handler-launch-3.0.3.1-80xIOWhnBKj1cpajNd5bhx
    warp-3.3.30-Dns0BUI9BD6AAY9Q0OBUfS
    yaml-0.11.11.2-1OLXpDDsFNdE7taydwTioX
    yesod-1.6.2.1-f3VJOS8st1DAoTULcrrNI
    yesod-core-1.6.27.1-15ixOMt9Yrv7KjomxHnqQ1
    yesod-form-1.7.9-JY3TWz2tv4XJpMSW9aUEJs
    yesod-static-1.6.1.0-uUhZor7PamICUVKtwySz6
    yesod-test-1.6.23-KRhssn9MgpNKs6IJ4w2UJ3

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

