#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.40
visibility:           public
id:                   hledger-web-1.40-FhOle6kyRT55W6eXXbCmba
key:                  hledger-web-1.40-FhOle6kyRT55W6eXXbCmba
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  0fa5639c2555e5847c15423b45cf1005
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.40-FhOle6kyRT55W6eXXbCmba
depends:
    Decimal-0.5.2-L1ruNiquHrYAqRT7P1WjVY
    aeson-2.1.2.1-U8Qicry0zF1f9E1tHxOto base-4.17.2.1
    base64-1.0-HeEOWq27DcN72imREYEe53
    blaze-html-0.9.2.0-148ZoU8BzetFm1jSAQ9JQP
    blaze-markup-0.8.3.0-KN3syb3Jq5SH5jCxIlubmm bytestring-0.11.5.3
    case-insensitive-1.2.1.0-2YJdsrn6pUkJFkSDuYKbj5
    clientsession-0.9.3.0-JnQ0RfcYJR22UyCQg8Zx1v
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-JCExIuyhnVmH352zfSD7FS
    conduit-extra-1.3.8-E2T0R9dVEp0LoFKbSS1RVP containers-0.6.7
    data-default-0.7.1.2-2qohbnSvS9oK93FFGOJ5gM directory-1.3.7.1
    extra-1.7.16-10qHBEVCUWpyHAHSzHKIa filepath-1.4.2.2
    githash-0.1.6.3-5todB4akPaH3OSpVGPtgnj
    hjsmin-0.2.1-RiMfnoreS75z1BLxPhLyu
    hledger-1.40-IObh5353OU8AjBydLyTgC0
    hledger-lib-1.40-CRz68OzCGWQFjFCYEWajnF
    hspec-2.11.0.1-9Wwr4Gy8Dh9L51n4qncJuJ
    http-client-0.7.19-LmgoxlGljmmJ4yfMmVG9tj
    http-conduit-2.3.9.1-J292KvN886fE8zWfrCuHoH
    http-types-0.12.4-36n5pJIqV0vLBUyZ9LbmPR
    megaparsec-9.7.0-6vU2vxyqrAyGY5juwv0O1p mtl-2.2.2
    network-3.1.4.0-7Sk2RzgIXBW6VjX8wm0Jln
    safe-0.3.21-7gkAsJZkXd98KDZOjDkxED
    shakespeare-2.1.4-cSRRpNDj669qI4MmXAOP3 template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-LBxlfXjsbERDOpdX4AlQOF
    unordered-containers-0.2.20-KWLixwBKCEK6ORqUSVo2CW
    utf8-string-1.0.2-3k9iW3aOua82FWJzfAeOkO
    wai-3.2.4-IaIgYS6oHRf4vNU7eyANj2
    wai-cors-0.2.7-9tOUmbcdnHx5YEBhB3heFC
    wai-extra-3.1.17-5259534qMWv4hXv32Xx1GM
    wai-handler-launch-3.0.3.1-CTe6xGQGsZKAcnS9jbrZX
    warp-3.3.30-4GBGPykkC212vYYZdvLYEB
    yaml-0.11.11.2-6eupV0k4gn5IQ1N6C4WLxC
    yesod-1.6.2.1-4KJvoxpUbfKBIdy17icybx
    yesod-core-1.6.27.1-7F9UsXUEhQdCbagwfOcdYg
    yesod-form-1.7.9-oKEeZg2HbT8qwkXwpAC1u
    yesod-static-1.6.1.0-7CYFJoQB4lGH2k06ehbXcU
    yesod-test-1.6.23-J0kPpSy3f1C4wZZRKTxflH

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

