#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.40
visibility:           public
id:                   hledger-web-1.40-Habi8ymjw8j8XIyYFS76NG
key:                  hledger-web-1.40-Habi8ymjw8j8XIyYFS76NG
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  9aa24308479ed8cb498dbcdaf7a86aa3
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.40-Habi8ymjw8j8XIyYFS76NG
depends:
    Decimal-0.5.2-1Cfe5OFRYS0HumJpzR79eu
    aeson-2.1.2.1-56YME0rnoff9HEf3dDitk2 base-4.17.2.1
    base64-0.4.2.4-9yHNgMqHoYK35fxTxRcuNp
    blaze-html-0.9.2.0-B9ruHJfpRcR5JjuSNAaIt4
    blaze-markup-0.8.3.0-5FWKxPQWriR2jdJTxmXBeL bytestring-0.11.5.3
    case-insensitive-1.2.1.0-6AEDVQFE46r4UgT1OZ8vwx
    clientsession-0.9.3.0-5wzMv042WHP3n7IJve8ToR
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-13kifNr5M5JAEtUuZRI8Tz
    conduit-extra-1.3.8-Z3oKkUHnho6cPgZd14hsr containers-0.6.7
    data-default-0.7.1.2-2qohbnSvS9oK93FFGOJ5gM directory-1.3.7.1
    extra-1.7.16-Dgi54UFR6GCKBQxJKK3PNm filepath-1.4.2.2
    githash-0.1.6.3-F5IH3paueem2ygsVjA18rO
    hjsmin-0.2.1-KaPCVecq3ECGHIQ2MxgVnh
    hledger-1.40-A01qGMcCZMK3e1Q6UglI1w
    hledger-lib-1.40-9T0HccJZvsbHPIlNlVOKuo
    hspec-2.11.0.1-6b4YOJR8c2J154RX4r9clw
    http-client-0.7.19-Iv0FNpcg1x0FpQ6t2lbifU
    http-conduit-2.3.9.1-8WpYQnyLKne61lfLOyMZFN
    http-types-0.12.4-GF9q12zDyJCA1fCuHO5qN
    megaparsec-9.7.0-8QcUjVGbdbIDZ3h44NDcYc mtl-2.2.2
    network-3.1.4.0-1ps2oXOoyxa7GsNgS88GCq
    safe-0.3.21-394GYPspEtM9PWWR5I1WHV
    shakespeare-2.1.4-BcFYvcs8ISt2K2PCeOyZ2s template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-IR9uEbNEBGbEspkibOUysa
    unordered-containers-0.2.20-90liAnN3BtD8VAzg2AGnlq
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-3Rb2R2bry06JIe4wFfvRMb
    wai-cors-0.2.7-Bpbz54VvcObBkYHCsDXNbX
    wai-extra-3.1.17-1eWeWEEVVHB2oyc6kVUeTP
    wai-handler-launch-3.0.3.1-3R1EYDi8Ki5GQCTwaKGHEg
    warp-3.3.30-8PDlMvIdVjIArgEuVld1EH
    yaml-0.11.11.2-3LwkyNFNkgJAypCQnGUd7j
    yesod-1.6.2.1-4cyb80w6yeB908wlcnjw4Q
    yesod-core-1.6.27.1-DGf6IsRBwZx7oHWtWw1Ebi
    yesod-form-1.7.9-8D6PgFF6kLu6pCs4FaNPkZ
    yesod-static-1.6.1.0-F0btkgFMvER5cXKkpqCV9X
    yesod-test-1.6.23-DbJkW2D3dOD9Xsrcqqr2wp

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

