#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.40
visibility:           public
id:                   hledger-web-1.40-8jAkmMud2rCKyjCva3WokM
key:                  hledger-web-1.40-8jAkmMud2rCKyjCva3WokM
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  8aff5d5108683869be638fa154bb2635
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.40-8jAkmMud2rCKyjCva3WokM
depends:
    Decimal-0.5.2-BKPdP2MprswCsMwpVspj8b
    aeson-2.1.2.1-GhEX0nU3rpe2rpNz8TrqEz base-4.17.2.1
    base64-0.4.2.4-1Zwhyti2oBh7bAvG1RDEcv
    blaze-html-0.9.2.0-EVafAfeFFsi6uTiWDNT8VW
    blaze-markup-0.8.3.0-5DZhbkei3UTFzR0H9aIui1 bytestring-0.11.5.3
    case-insensitive-1.2.1.0-4S8KsHm7tqa4BSXUqBqEFP
    clientsession-0.9.3.0-D0XR0zQOcdjH2jFjylWQ4h
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-4gghCzlDHkwDP6CgdQyket
    conduit-extra-1.3.8-G9lFzvhsWCC98MvCUjkory containers-0.6.7
    data-default-0.7.1.2-2qohbnSvS9oK93FFGOJ5gM directory-1.3.7.1
    extra-1.7.16-ImLCklv7ADgBRpiTCR29Rj filepath-1.4.2.2
    githash-0.1.6.3-BM4yoEyl18pFBGlp7RlGTS
    hjsmin-0.2.1-7ogVbMzuwCmLfneFBuJxxr
    hledger-1.40-6jqETAaPsqLBKO8GRMKZ75
    hledger-lib-1.40-BoMX2Xu05o7F6ToSgamPi7
    hspec-2.11.0.1-F1U3olYL3JN6953m1gXN3g
    http-client-0.7.19-2gxWIBw6DZOLOrOirSGCjs
    http-conduit-2.3.9.1-7muBD1166MhJslMFfttyN
    http-types-0.12.4-8AFNw5oQ8TE9V2A9rZjrTr
    megaparsec-9.7.0-4uCmo2rz8QPI88LtUBVGYi mtl-2.2.2
    network-3.1.4.0-GjkG889aAvvIfieaCEFwUy
    safe-0.3.21-5tBPY9DXWHX1cPmFJ7tzkO
    shakespeare-2.1.4-Jpnn6GorD9F8uajFWul69L template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-HG505sH2B9u2NzkBqafBkg
    unordered-containers-0.2.20-psp1ib8v1R5J9F619BTWH
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-7AO9d5JyralLoyfSO8kkij
    wai-cors-0.2.7-6aZY9ZpNmwCIn4ajw984rA
    wai-extra-3.1.17-DxFwVatTeNLlcKV8bcmaH
    wai-handler-launch-3.0.3.1-FPBBOeMOWQD7muz0sU04aZ
    warp-3.3.30-SQgNLAClSCLXsKRoqZBVX
    yaml-0.11.11.2-2PHSDbME2Gm506CTHgYBfF
    yesod-1.6.2.1-3xTObk2khP1D4R940XXHin
    yesod-core-1.6.27.1-LRbp67ywK96BLf56lpJxf9
    yesod-form-1.7.9-B7bhlhTEiOEKFBjc45yvdC
    yesod-static-1.6.1.0-HbfQzy8oJz67nsgxLb7vSa
    yesod-test-1.6.23-7ajk6E7SggEEIu8REvmyqc

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

