#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.40
visibility:           public
id:                   hledger-web-1.40-KbGdaY6jS2ABjTy7l6ioiP
key:                  hledger-web-1.40-KbGdaY6jS2ABjTy7l6ioiP
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  1db0a7ee3bc071d2df5f488cc22d360a
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.40-KbGdaY6jS2ABjTy7l6ioiP
depends:
    Decimal-0.5.2-KkKlbvqDhF71VcwFYE5Bn9
    aeson-2.1.2.1-JflO2jKMgLf4qHLretO6v3 base-4.17.2.1
    base64-0.4.2.4-IjHZitHB3O4632IHaNCiQX
    blaze-html-0.9.2.0-Flt3Tc7vZ1qFeyjyRV9cWw
    blaze-markup-0.8.3.0-2V3MXZdaeBa5lesIVE9nmc bytestring-0.11.5.3
    case-insensitive-1.2.1.0-BbofItWtqOBJTc7ifMkeDp
    clientsession-0.9.3.0-NGVgORYxeuExzRWZsgoEI
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-4Nkot2oDvonGGjTJfFocsW
    conduit-extra-1.3.8-8CivwHQF58ICNk5roA6vHC containers-0.6.7
    data-default-0.7.1.2-95OdNmNpLKa9cNDp3ZlqO5 directory-1.3.7.1
    extra-1.7.16-JrkKNFcdCdl6EDBR7hubAr filepath-1.4.2.2
    githash-0.1.6.3-K71CsNKxHJsKZNt2TTDu6a
    hjsmin-0.2.1-AEdPDlfPEOMFFXdMPptDC5
    hledger-1.40-EwlD1vf1STHHrzYY2IIG42
    hledger-lib-1.40-IgVIvEyzzjC4dYOTzgpdt4
    hspec-2.11.0.1-4krmWrIf18WEWoorq0tBw3
    http-client-0.7.19-AzjKmN88iKpHUThQVz5Oi6
    http-conduit-2.3.9.1-4hRwe05FGzI92S2AutjhUJ
    http-types-0.12.4-IN69whTTZpTCgL5hadx0pQ
    megaparsec-9.7.0-FHgjCkAAg7CFkxuBfGOMbb mtl-2.2.2
    network-3.1.4.0-HEqaUi724nxGs7WtLdNH8M
    safe-0.3.21-6MceIPNvQ5TJvgy4CdUtuY
    shakespeare-2.1.4-1FdInTIW71KBYOy4NlPSM3 template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-2QwnBrWekoc6SOPsPeItcF
    unordered-containers-0.2.20-Eo1ocpXri5ABLOF81VToPu
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-5jTd0UWsGpkHy031tY6wSU
    wai-cors-0.2.7-J5opACD9Ieu4lH53kZ5BYh
    wai-extra-3.1.17-7aOaJRPpRVD3oIMcjFi9xX
    wai-handler-launch-3.0.3.1-BtBOKF4OOIZ8fgdUrBGf4y
    warp-3.3.30-4gSKOE93iSYFw6AC4opjX0
    yaml-0.11.11.2-84UPmeumPbZAgvb7LaRIdh
    yesod-1.6.2.1-BR2JELdVmfHEE8I3BUWJia
    yesod-core-1.6.27.1-AJl5Rfu0USzFqDRkMojFBM
    yesod-form-1.7.9-8aCt9GupFASF3BtUrMxScT
    yesod-static-1.6.1.0-5MFV9OVUWrxAcFjpH6KEu5
    yesod-test-1.6.23-1CEOGMtpud0LoqwFdBIkon

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

