#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.40
visibility:           public
id:                   hledger-web-1.40-Dv3rh5glXSL2nnEd3PRs6Q
key:                  hledger-web-1.40-Dv3rh5glXSL2nnEd3PRs6Q
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  809fb076917d7d44f0c8f38617367c22
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.40-Dv3rh5glXSL2nnEd3PRs6Q
depends:
    Decimal-0.5.2-CcAic6wGmJ0FIzncuSXSiE
    aeson-2.1.2.1-6ANjbGmrSDg8K6hz3VmYXP base-4.17.2.1
    base64-0.4.2.4-EM7Otw2yKy78mxLsNsLilI
    blaze-html-0.9.2.0-Ji537hcwMq4HoKqYAGHtNW
    blaze-markup-0.8.3.0-6OwWTNZq6xt8UyuSSVrGHt bytestring-0.11.5.3
    case-insensitive-1.2.1.0-IP68CV0DvpE446u5n94xId
    clientsession-0.9.3.0-EtTUj3h8h4j3cJk5yC7Q5l
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-4l30t2Ip4GHEHw4ixGv2i5
    conduit-extra-1.3.8-GK7eB8KrTj0DDdk6UIy2sa containers-0.6.7
    data-default-0.7.1.2-GUUW0V5lisrJnDmYs4YZIH directory-1.3.7.1
    extra-1.7.16-I47Rfrva8J15uJNg6ub4mo filepath-1.4.2.2
    githash-0.1.6.3-FUSYMp6VGRJKFQMBseVTkR
    hjsmin-0.2.1-9StHo7RAD0R6QWjmv2zlDk
    hledger-1.40-ekhyZyNSVkF0o6hnV1xgR
    hledger-lib-1.40-Gr8rAC9swnNGkAaa9lKulx
    hspec-2.11.0.1-HxRndPHMvvIESPZ52O3U93
    http-client-0.7.19-INRexYbbc84G8M9afYhYa4
    http-conduit-2.3.9.1-IrgIKKd9NOlKX1Xpi2KNUa
    http-types-0.12.4-BDAI9vbdFnhAzARYRhzpQY
    megaparsec-9.7.0-11G1C9ltcKPC7KewoELwDN mtl-2.2.2
    network-3.1.4.0-480JOeNLV9o5fbqpzcHJCB
    safe-0.3.21-95M34uAYizmIkn1zPFtQ36
    shakespeare-2.1.4-LvNTWbo8AQxAR33PthOhdo template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-HfukfXMXV6LHwjUE321L3t
    unordered-containers-0.2.20-6WajAJaPEOH3f3auRxdjt7
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-JB43hXdVXtN8JMxxOtVTHM
    wai-cors-0.2.7-5n5Y3WLKA5OJGsVTtUgUPp
    wai-extra-3.1.17-50DvAWuky9YHDLnfOAaaIi
    wai-handler-launch-3.0.3.1-ANZ1zjmQf7SI2diQivwss3
    warp-3.3.30-CrPaA8J74RpDAzaRjUdTYd
    yaml-0.11.11.2-6eLqTH2y8Fa133KzujCnx8
    yesod-1.6.2.1-9wziQRp2BFjL7ODeGZLcXn
    yesod-core-1.6.27.1-LyTjJRvs0ce2wFZg3sjJG
    yesod-form-1.7.9-6UQBVZl6CPeEC1sJ0C06uK
    yesod-static-1.6.1.0-7NDF3X3us5jGWZ6eX1Gw4f
    yesod-test-1.6.23-7KfWTLx9zYP1cNOaSEGQzK

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

