#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.40
visibility:           public
id:                   hledger-web-1.40-EUgb3OaEurfLGqmSUtfANk
key:                  hledger-web-1.40-EUgb3OaEurfLGqmSUtfANk
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  c36e30cddcebde1a6238a29e9fdaf19b
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.40-EUgb3OaEurfLGqmSUtfANk
depends:
    Decimal-0.5.2-A1SMh7hXfsxKLbsyandonN
    aeson-2.1.2.1-AuEsVg6Hhe2CPhaLp40FYe base-4.17.2.1
    base64-0.4.2.4-KAvIwXHVuuT89rGXm8BFq7
    blaze-html-0.9.2.0-2tQrpPPktTE9kc7YupDhad
    blaze-markup-0.8.3.0-85ZHP4aqjGL9MlqBcdxWNZ bytestring-0.11.5.3
    case-insensitive-1.2.1.0-FtXwbgcyUdT58mvaxnolJS
    clientsession-0.9.3.0-2jGSX8Wzh0V1zTRuluROb6
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-2pDJ8cGA0RdFcphD3YNS0I
    conduit-extra-1.3.8-H04TTvw0t7l32MCx104BBa containers-0.6.7
    data-default-0.7.1.2-95OdNmNpLKa9cNDp3ZlqO5 directory-1.3.7.1
    extra-1.7.16-2NFI8foRfl5F586yJkh1o1 filepath-1.4.2.2
    githash-0.1.6.3-HI1RLsMequCAAgcBW59P5E
    hjsmin-0.2.1-K4qCRcx0Nus9QAbNlDmnCn
    hledger-1.40-Hi60tha9LFkAbAHrkYuP3M
    hledger-lib-1.40-3tswfd6mhIU9cY9FQQ5UBU
    hspec-2.11.0.1-4URV1ceHHyT9m270VejX3G
    http-client-0.7.19-veq4MTHniy21v9pOYpRdd
    http-conduit-2.3.9.1-8bxAH0k07PX13M7HRtwP2b
    http-types-0.12.4-KxfEKIoLDdBKlrGUyHct4y
    megaparsec-9.7.0-B43tSYbC6tf2tuA1FPKzy1 mtl-2.2.2
    network-3.1.4.0-HbZCj3UHcZsFvn6ftFrD4m
    safe-0.3.21-8kVaTUiukdbF02Sa2bWRZd
    shakespeare-2.1.4-7Isq9dKnSNMdn9XOajiyU template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-CuldQnaf1nH9gOZ1eDmEZL
    unordered-containers-0.2.20-FOY8P5Y3sqjANbVUEJi9Vi
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-5eTAAfrYzv8Cj5jt7kPDLd
    wai-cors-0.2.7-4aK95z55DfODMvZCoVbeUn
    wai-extra-3.1.17-725EK6xKvUCJXMQKiZrmau
    wai-handler-launch-3.0.3.1-AKLQkuu5IUJE6FrGBnBPuH
    warp-3.3.30-6f86FwsrA0q9gyhbhZhd7N
    yaml-0.11.11.2-46QNKBlQxe67SIHc4SHjVB
    yesod-1.6.2.1-3Rp69aUO8tfCZlZMxIVSqH
    yesod-core-1.6.27.1-JImFTywHvfo66TuKcCDyGK
    yesod-form-1.7.9-CpqmG3n85JO57eobz1Mnds
    yesod-static-1.6.1.0-9w3aROCFkA996ZlTSUOrpE
    yesod-test-1.6.23-1Tl1p7JayuqEDNRtm4XtU

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

