#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.40
visibility:           public
id:                   hledger-web-1.40-Jr3ZRHRRah72mBl7FcLxMZ
key:                  hledger-web-1.40-Jr3ZRHRRah72mBl7FcLxMZ
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  e16c5b9ea446ba80054360dafbcb4e1a
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.40-Jr3ZRHRRah72mBl7FcLxMZ
depends:
    Decimal-0.5.2-FtVGHDZ0AWuKcPODcAYeX
    aeson-2.1.2.1-9cza8YJPY5Z8Ze3x8zf5ig base-4.17.2.1
    base64-0.4.2.4-DKip0fqpDjzASP5wZBdUNb
    blaze-html-0.9.2.0-LlU0XfzVpg34MJkFx2EZcl
    blaze-markup-0.8.3.0-Jmy6mhQ8sFNHEauj2dm6FF bytestring-0.11.5.3
    case-insensitive-1.2.1.0-9yImpzTIYpBJ0v1fZqtWOj
    clientsession-0.9.3.0-9MK6v3dLoPK8SO18u9rtfg
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-3M1B5TjJPZk646ipFSI00d
    conduit-extra-1.3.8-BV0bH3FRcPVLYpMYNDmntB containers-0.6.7
    data-default-0.7.1.2-1WYBg9tpZep2i2jrc12PQs directory-1.3.7.1
    extra-1.7.16-25w24qfmnFvBWuXuQdORRQ filepath-1.4.2.2
    githash-0.1.6.3-9aK9FTRVlnxJ13xvjdPA0S
    hjsmin-0.2.1-B6V6sdTkeOF4S3kiPv12Mk
    hledger-1.40-2cnOaEwpBc1H3qtRN6XxIS
    hledger-lib-1.40-Kijb2GBDgUDHAb79E485pD
    hspec-2.11.0.1-CDO8R1xRMZxCmPYboGB1j1
    http-client-0.7.19-2IAKaL0RajRLDWsZpaLmo9
    http-conduit-2.3.9.1-2oN63nNuS8WGGNMCJvNhJ6
    http-types-0.12.4-JKUCrzdlATTa7w8tKVNt1
    megaparsec-9.7.0-G88a36osNzSFo1446urB6s mtl-2.2.2
    network-3.1.4.0-DD61ZgteIR5Dyq0QRyt6FX
    safe-0.3.21-3NYlWmvK5NXAlxNW2aDsvC
    shakespeare-2.1.4-CfH7ajohA5QDYTItoTkzc5 template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-Gp2OJygcIQQ2h6Czdh8sny
    unordered-containers-0.2.20-8cMd7edANcDBeBDjVdjsZY
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-9F025KLztrGD7Hr5xRYA73
    wai-cors-0.2.7-GdNYcZUF8qt45NMuJQx4z3
    wai-extra-3.1.17-CEHyRGVaNjy2F1ffZ5B4e0
    wai-handler-launch-3.0.3.1-A8HDSZ0sMlo5R0iykiOpjR
    warp-3.3.30-72Ydn4shR1tASFwwoxKSFx
    yaml-0.11.11.2-iqefifTpcf4cjDHBfWE54
    yesod-1.6.2.1-B0wBvARTHprIbonZ2vqwjw
    yesod-core-1.6.27.1-Jbwti0Pu9DIIn4mS0o789w
    yesod-form-1.7.9-3iype3v3oIZLlsH9N5cqpd
    yesod-static-1.6.1.0-AfFGWtFsqVtIHDgYtqT7Ui
    yesod-test-1.6.23-EFAIMXXPGhjFjWWGGfMOQP

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

