#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.40
visibility:           public
id:                   hledger-web-1.40-8oYOIYLeeXjFepGx3m0sGo
key:                  hledger-web-1.40-8oYOIYLeeXjFepGx3m0sGo
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  9472f185712b9ebeb689a3ce2135e785
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.40-8oYOIYLeeXjFepGx3m0sGo
depends:
    Decimal-0.5.2-36PsXhmwtQk5hlFACGOX1e
    aeson-2.1.2.1-Eu0ZMA1fvZJ7acphaZ1YUp base-4.17.2.1
    base64-0.4.2.4-KkOoDuDFNVP313fVZjsw2i
    blaze-html-0.9.2.0-9WgJSHLeSKZHZJZeAqHdGu
    blaze-markup-0.8.3.0-CJuRWkQj3FH3GFEjkD1DfK bytestring-0.11.5.3
    case-insensitive-1.2.1.0-ELM66iRIeZm6Dg1Td1yG95
    clientsession-0.9.3.0-FE8zjsFcvqj2ElPNSObZ94
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-83ARrK7GmQf2qu3DMBdhJp
    conduit-extra-1.3.8-B8bAMFDMheG5al1OhhjaT3 containers-0.6.7
    data-default-0.7.1.2-LONLsSvT4G81IL8ks6Ql72 directory-1.3.7.1
    extra-1.7.16-ARVAqO8RyG5El3VvrEfrR4 filepath-1.4.2.2
    githash-0.1.6.3-1S4T48jjMnQ8ZEJrGfoYjJ
    hjsmin-0.2.1-1qeXKY2XQqrDsBcokEEzkx
    hledger-1.40-7IGAAf6nDkvDqLcyFfxihA
    hledger-lib-1.40-6EJJey6XIhw2E1CbcIqdb
    hspec-2.11.0.1-2eE4SMEtb24CqoCsM4thi0
    http-client-0.7.19-3rmvGvyaabxFxCJ9oJ0aDx
    http-conduit-2.3.9.1-7Oc6YAxQlM34vEzwEGx8Ed
    http-types-0.12.4-AxSTuELtXS8Ebx20Rd9Bgd
    megaparsec-9.7.0-L9yzYQswnVIEfh0e6mQmZ2 mtl-2.2.2
    network-3.1.4.0-L9DLhdoHw8O9GdA4IbhXs2
    safe-0.3.21-29OHNU5kqwB6czdAzMhG9H
    shakespeare-2.1.4-BqCBNuiGeItAWU2nXraps4 template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-7O49sxXSp3B9cDegRW2Oej
    unordered-containers-0.2.20-5YE9FG6zPmjDjdA4DCPpEY
    utf8-string-1.0.2-JoSH3X8qo5Q4jcipebjMdu
    wai-3.2.4-5nckpzENK0CITF1tUzznAA
    wai-cors-0.2.7-LIT1zmLFmcIGARasyzMPMT
    wai-extra-3.1.17-A3Ju7Mri5IX9KSq1PzaeVA
    wai-handler-launch-3.0.3.1-3bs328IUEdPASfwW0jcC6V
    warp-3.3.30-78kwL514AOQ600YH2WDhVm
    yaml-0.11.11.2-EKBPmCiMj6M3VUx6tnOPEL
    yesod-1.6.2.1-DWja9YAqZ94BB4UBp95IiY
    yesod-core-1.6.27.1-1wgAz0l54QCBHFBKkUWazG
    yesod-form-1.7.9-IA2Inpg39g8LNUGrb5ZZBA
    yesod-static-1.6.1.0-I5zLvMxz4EwD7uGr6gQjgW
    yesod-test-1.6.23-1TmIjy5Jq6uKH3G4umvTxc

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

