#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.40
visibility:           public
id:                   hledger-web-1.40-HetBomNDzJB8mhKdggydQ7
key:                  hledger-web-1.40-HetBomNDzJB8mhKdggydQ7
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  0285250c4a130b8bcfc659b314798973
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.40-HetBomNDzJB8mhKdggydQ7
depends:
    Decimal-0.5.2-EuHKrdxxLfM647iRI612ur
    aeson-2.1.2.1-6LfdTurWC20A9IWYLs821k base-4.17.2.1
    base64-0.4.2.4-2QaAOtaqpG1nWZgt2Ruv2
    blaze-html-0.9.2.0-Bv8614wD5Ai8TMb1zcEXer
    blaze-markup-0.8.3.0-B1HCckPc2PmDZdNSEMeP4u bytestring-0.11.5.3
    case-insensitive-1.2.1.0-5l2QOpNdY1A6hVaz3nH17n
    clientsession-0.9.3.0-GzP7K9lA8Ev3uhG2frMsTW
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-EVJ10prSzIP4i22LIWcNGH
    conduit-extra-1.3.8-6X110wJXrg3AO7uiFEQyud containers-0.6.7
    data-default-0.7.1.2-CrFQ4dgXZ2xCKxCENN7hDD directory-1.3.7.1
    extra-1.7.16-LkdJ4kpBBKLHRRUCxLvq3e filepath-1.4.2.2
    githash-0.1.6.3-JrnmHw2vJBpDkUKJm5Sfoc
    hjsmin-0.2.1-Lr7y8Q9xkBcBOoLrn29OGT
    hledger-1.40-HTizTjF69kw9JITFWqxg1I
    hledger-lib-1.40-Qq9jBdRsGtKurfOZKfT7
    hspec-2.11.0-LR4IK8Mdk5gBH9wzqYh6vy
    http-client-0.7.18-9qBJxh17yshDwYABVFlZAq
    http-conduit-2.3.9.1-xu7tQ8G5ehFgwcUliYifC
    http-types-0.12.4-1Pq1Zy5bmQBJRy3r5PsBE
    megaparsec-9.6.1-AoOr20KJpsLF6iC5XVolQ8 mtl-2.2.2
    network-3.1.4.0-Clrm8B2IBAjIFHTKmEcInu
    safe-0.3.21-6Oovu03etStGOLdQZdsNsh
    shakespeare-2.1.3-8CUSzaeWw65JSgXySG4QSZ template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4-G4SKwUBWRB0BAMhxExxVa1
    unordered-containers-0.2.20-3iRUctzIz2JCUYhLp7SKku
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-84onj9aucoXBC5yY5F84Os
    wai-cors-0.2.7-GFyBjjGyTZYDPu08iwgIS3
    wai-extra-3.1.17-Hamcub5AkX2FkkZjhDMiE2
    wai-handler-launch-3.0.3.1-D1CUG3s6pFkI3UYKGaMUNk
    warp-3.3.30-9Zxn2kwWyMQK8cAG5JiXwE
    yaml-0.11.11.2-KnxpqCR1yjUDjP7kCxMY6Q
    yesod-1.6.2.1-6HyqRmCM10JfSu4hLxEvP
    yesod-core-1.6.27.1-HlSFt5U7crm7kk45IFTABj
    yesod-form-1.7.9-DEZqN95UEAgFtAoGoOKW6M
    yesod-static-1.6.1.0-dEFlXKsIc6DrBfZ9WmS2y
    yesod-test-1.6.23-LkTT309ZWygC96eGmshhR4

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

