#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.40
visibility:           public
id:                   hledger-web-1.40-7cZNahtXWpCAwT7yabjmY9
key:                  hledger-web-1.40-7cZNahtXWpCAwT7yabjmY9
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  19009705de8f0516e5582d9336afd306
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.40-7cZNahtXWpCAwT7yabjmY9
depends:
    Decimal-0.5.2-2XVal5lMAfQFihmBZmbNe1
    aeson-2.1.2.1-J19dEw13kUOF5hLEOQVj2r base-4.17.2.1
    base64-0.4.2.4-6iHGjk0amyXDtKFouPcRCt
    blaze-html-0.9.2.0-KGNUVzd5sBrDaiavnWufWj
    blaze-markup-0.8.3.0-BQHgx8yAxJB0rzkVyHbGy bytestring-0.11.5.3
    case-insensitive-1.2.1.0-A0C3sKUh8bjBoKTAh9uBrV
    clientsession-0.9.3.0-ImrDCoJgvxn3s1NqNqj5j3
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-8TpelrREvnT4UWeHn1EPBu
    conduit-extra-1.3.8-1cZTDXEQEzzCMaWxMuhSnE containers-0.6.7
    data-default-0.7.1.2-LONLsSvT4G81IL8ks6Ql72 directory-1.3.7.1
    extra-1.7.16-DOwdXWfQN4O1hxxIx77WWM filepath-1.4.2.2
    githash-0.1.6.3-1AgjSFyXmnbIU0GC9an0FJ
    hjsmin-0.2.1-Jqy8KPGLvBHExu4x8rkpP2
    hledger-1.40-9BmIIPg48loANaEmiHoHn8
    hledger-lib-1.40-EyHVtUE11AtCqaDvQ0PT9C
    hspec-2.11.0.1-DRUkubAKdShC9Plk8PyUpt
    http-client-0.7.19-KicVexkpqk4oKge5Ko4JA
    http-conduit-2.3.9.1-Is47YqgNB24FI1nCDxgqAX
    http-types-0.12.4-3tEQsAXlW3W83gTXUT3vtQ
    megaparsec-9.7.0-7JToewzpODIKYsxdMWTRd1 mtl-2.2.2
    network-3.1.4.0-Aot7Hsnd3no7HIoU7vrrpP
    safe-0.3.21-BTgY19Ix98PEQ0IXGyRX6s
    shakespeare-2.1.4-LG7SJ5VEgFRJXKBI4uqtMx template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-3FdbTf0wHyAAtiLARGDxS5
    unordered-containers-0.2.20-1i1FNKzvn6TI2R1AzcNrcz
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-FyKF4IGn0hJInObjv662sx
    wai-cors-0.2.7-9QBY3LjV73Y9QS3rcLn5k3
    wai-extra-3.1.17-GJnt0L70qq262BkWboBhQX
    wai-handler-launch-3.0.3.1-B2NZoYgH10KCxJZZqSc575
    warp-3.3.30-CPK0BWevn9n1L9qMk5skmB
    yaml-0.11.11.2-IP6pxSwokcg3qM5MhOIp2
    yesod-1.6.2.1-DNQTzZpvo8cGx4FSmkD7jo
    yesod-core-1.6.27.1-1NW7cmaVi3QJLy9tg7wqrt
    yesod-form-1.7.9-DHmUW2fK5iu4wnvGxpAx2P
    yesod-static-1.6.1.0-3XXvGNZqU5vJuhiLmnNHkh
    yesod-test-1.6.23-LNfcSvvf5hCHFFSafckEgX

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

