#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.40
visibility:           public
id:                   hledger-web-1.40-DMMgMhQkoWW321vYziWGq3
key:                  hledger-web-1.40-DMMgMhQkoWW321vYziWGq3
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  f761ee53d81746ed8e881b6a93db3c81
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.40-DMMgMhQkoWW321vYziWGq3
depends:
    Decimal-0.5.2-Er61YTwE6a56Q4h4iIBkcV
    aeson-2.1.2.1-4ODQ1UQyjV4HqW8vjPOsEA base-4.17.2.1
    base64-0.4.2.4-HWZ73VAsfNIJNyyuoFSC67
    blaze-html-0.9.2.0-7pVTZvIJYQUCkg3YqAUW9g
    blaze-markup-0.8.3.0-4j60nhp7LH6IM9l3EcpM4T bytestring-0.11.5.3
    case-insensitive-1.2.1.0-6fVgEt7vrFc1sDHTeWeWXd
    clientsession-0.9.3.0-8Mm6eT7frZYKLBaO2Ei97w
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-8EwOhhDv3r5EX0bCaWMPRW
    conduit-extra-1.3.8-5wj2QtagE3YHzOewcAu6yq containers-0.6.7
    data-default-0.7.1.2-8yRIq8kwMNHG7OFJsT5Ayy directory-1.3.7.1
    extra-1.7.16-DQhMeKr0WjwFMe69BFFypt filepath-1.4.2.2
    githash-0.1.6.3-Ig5oaRupCrJLV3orW32rWG
    hjsmin-0.2.1-JN9mMeFvWK5HGeM5dsgoHG
    hledger-1.40-BKughDCuoBI7ENiRJK1bzL
    hledger-lib-1.40-4YYS7FiwEajLWQ6Bf2TFGn
    hspec-2.11.0.1-81deCvlIPZJEHrVU6JHOLD
    http-client-0.7.19-GBWZtgLxevaKnflbUYdsDc
    http-conduit-2.3.9.1-8mObH8kQTvq5rsa8XUzz9R
    http-types-0.12.4-ALPJWcgMeIc83stb9QW9Gl
    megaparsec-9.7.0-DEUv5YUmdT01sIVP4Xv3Ec mtl-2.2.2
    network-3.1.4.0-9ZkyLgutzTZFWrHs4BgIgX
    safe-0.3.21-DIKqONX7AP7ND62kUZ2Ce
    shakespeare-2.1.4-1kv2vId1ROu16RWI9Hqjjy template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-Vv5ZVefh6nKwhTswwMae7
    unordered-containers-0.2.20-7dvM9aaOf5JATet72j0BPX
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-1yop7BvplydTH1djBo1do
    wai-cors-0.2.7-9bCH1NveGicFjiBDsjSJu7
    wai-extra-3.1.17-BqkJjRoAdGnJ0inpYtyqgr
    wai-handler-launch-3.0.3.1-KFA26m1KhZfBF6uRgIe4CV
    warp-3.3.30-8OpZYlaRw56DjKQnzqAXnQ
    yaml-0.11.11.2-8GnRgmaCyu6Pbssx6hiju
    yesod-1.6.2.1-EZ7d2GTCHVP32t23QSE6km
    yesod-core-1.6.27.1-JrV2pGG2Dr2B4fVSHpoyAw
    yesod-form-1.7.9-EJyCyATzNWG7ToE5OCPrnf
    yesod-static-1.6.1.0-4192tGN9IdP1Xv1h89Quyl
    yesod-test-1.6.23-363KTRPU4mGqx5NiGfkTj

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

