#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.40
visibility:           public
id:                   hledger-web-1.40-LIbXLyr3AQoL2zM5r3TEeW
key:                  hledger-web-1.40-LIbXLyr3AQoL2zM5r3TEeW
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  61520386937d155d994b2f182032b6ba
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.40-LIbXLyr3AQoL2zM5r3TEeW
depends:
    Decimal-0.5.2-1AlZgSdvq2o8KDbLErfGXD
    aeson-2.1.2.1-8PRfz0Kg6mwK2TOn7o5BkY base-4.17.2.1
    base64-0.4.2.4-DyoAZM0MHUS25s3nntpYnU
    blaze-html-0.9.2.0-DybkQGKrSyk6JOAprz1r5T
    blaze-markup-0.8.3.0-FFIe9nHGnn2LbV2liT8TRJ bytestring-0.11.5.3
    case-insensitive-1.2.1.0-5qBt9JHinkAC9eq4HZukmL
    clientsession-0.9.3.0-EEoS8xgt3wM2w2HcP8ii2f
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-JOByYHd4UhSLHkAURX473h
    conduit-extra-1.3.8-6krltdaujp79VudWk7QgcA containers-0.6.7
    data-default-0.7.1.2-8yRIq8kwMNHG7OFJsT5Ayy directory-1.3.7.1
    extra-1.7.16-RhNJqbxY8a77mG7dDYp5d filepath-1.4.2.2
    githash-0.1.6.3-855EcWGJQZZ9z1WOa6ASAK
    hjsmin-0.2.1-KyFlfpb57Qq8UbbE0CCg6m
    hledger-1.40-HWPB6Iz3mZQI1fyIBaCt0H
    hledger-lib-1.40-L2GELDDsVeU85vc71vfQUd
    hspec-2.11.0-GDE5YfNyetgJEJMppTexrW
    http-client-0.7.19-I6ux2Y5Y5B3B1KqARFMBuk
    http-conduit-2.3.9.1-GCaa2XuTyJGz4mDlubaVt
    http-types-0.12.4-LjVNkNK1odX2A9i2Pb0dvD
    megaparsec-9.7.0-JdLotAX9gxvJ8pGS1qwpyC mtl-2.2.2
    network-3.1.4.0-KmVGd8MQrab5lGMy9eMLcZ
    safe-0.3.21-HL4mjR4LPAfAu0GeFkJLe6
    shakespeare-2.1.4-HeiyZnsV2nR76DyoJc0Xci template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-Bmp2cJ2h6mdBp1j7fQ6Hc4
    unordered-containers-0.2.20-8Q4WKXtMGLf6eJrIPiNhPJ
    utf8-string-1.0.2-FAQSGuIUGqDKZx6mH04y15
    wai-3.2.4-JYES4h2pzGv7ciJ8Xc4lzy
    wai-cors-0.2.7-IgaG4bWiSTrD1ECAaMGg6t
    wai-extra-3.1.17-5emoYZ3ehHQ79dkWHgvuDI
    wai-handler-launch-3.0.3.1-CpUZayZVaKtyfoeWcoOZn
    warp-3.3.30-1d6vGs6WRyG5v9ZRSP283B
    yaml-0.11.11.2-1mgXi8h8FWFLhtN6GIAtya
    yesod-1.6.2.1-HPRbSXcyOwyBIHutoSu7oU
    yesod-core-1.6.27.1-Ld7E3EhgDW78p6yeLZtY12
    yesod-form-1.7.9-38BWoQa1Umx3j2fSsGYQ6H
    yesod-static-1.6.1.0-BqlDJcNHMlS16jitBpeQY3
    yesod-test-1.6.23-7ftH0Hdnq90K7fpBqzDwY4

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

