#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.40
visibility:           public
id:                   hledger-web-1.40-763LPHHjZCpJHsxRgaeQ6m
key:                  hledger-web-1.40-763LPHHjZCpJHsxRgaeQ6m
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  cc9aa422bf27658dd6181201cbd73d64
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.40-763LPHHjZCpJHsxRgaeQ6m
depends:
    Decimal-0.5.2-KX8sScqPfHoC0q9r3L0Dko
    aeson-2.1.2.1-H1ahbkp4Y7o4mfa4dlXJ2M base-4.17.2.1
    base64-0.4.2.4-JdsxJzsLUqoD5Bnfkz2yYD
    blaze-html-0.9.2.0-9XbYd3BuaoOCWGJeBuMwxI
    blaze-markup-0.8.3.0-6QvbZAZCbFl1UYXsobZak bytestring-0.11.5.3
    case-insensitive-1.2.1.0-9IA4WijhX2tEdiCE9R9PFI
    clientsession-0.9.3.0-9st6cKVevOnK4WZkTGM09C
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-Ft7mdP42es1IIbhkIhPjly
    conduit-extra-1.3.8-5HT9AVw3Boi2agSmskZi4i containers-0.6.7
    data-default-0.7.1.2-8yRIq8kwMNHG7OFJsT5Ayy directory-1.3.7.1
    extra-1.7.16-AjJ7EKi0DlX8yNMu4rkr1h filepath-1.4.2.2
    githash-0.1.6.3-GplkVxbXvpM7ZAFwh5XDLe
    hjsmin-0.2.1-XjaUZuxTjAHOQWtHy14nG
    hledger-1.40-GFsKRaYh7FMCQcohQXXTiZ
    hledger-lib-1.40-ft7gjf0C8P6Fy0LQwWU3o
    hspec-2.11.0-Ep21wOofZZQAfal1y6oOM4
    http-client-0.7.19-CGAsSsow8VECPfkY594gg8
    http-conduit-2.3.9.1-6ypk441yhg5EqCm31F4Jer
    http-types-0.12.4-72uTcx8GQYQBxIirpABdKe
    megaparsec-9.7.0-KfxQnMxH7036P9QuPFea8D mtl-2.2.2
    network-3.1.4.0-Ds1jGwhI6OBB7cQ3449UkE
    safe-0.3.21-Jsj2ePpKDeG8OpB2hRbMdb
    shakespeare-2.1.4-F24EjjaKoNg1iPt7O4N342 template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-HlnMhVbwTqwKYaVSlKHItf
    unordered-containers-0.2.20-L0GY6JfHBKC8QjVdSVYiO8
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-2RuDDCSyjKH9NHQ2ys4bpm
    wai-cors-0.2.7-9wDwrb8sjGB7PYuhONMUfa
    wai-extra-3.1.17-BOGNBmJPxlN8bDCz83zWJn
    wai-handler-launch-3.0.3.1-GmdoeU7j2ZtGCHpuP5qCSA
    warp-3.3.30-GcJT2PwZyNwL2mET1dh8pP
    yaml-0.11.11.2-Rd3OcnDsrb7QRDsbQR64S
    yesod-1.6.2.1-Kn0HDec4vnZJZRkX7iIwnP
    yesod-core-1.6.27.1-LybyUegxBISDHvCvAGIcPJ
    yesod-form-1.7.9-LCX8japkaZODA408kTd1Fm
    yesod-static-1.6.1.0-FgwzxLPl7kn99Dm1OriYn0
    yesod-test-1.6.23-27o7WXhnN7y3yQCwTRrJYV

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

