#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.40
visibility:           public
id:                   hledger-web-1.40-rc1buLXz4jIr3JU2LwMHO
key:                  hledger-web-1.40-rc1buLXz4jIr3JU2LwMHO
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  c7d737e8f1965bbe26468601c23ce906
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.40-rc1buLXz4jIr3JU2LwMHO
depends:
    Decimal-0.5.2-7ieshjqNIeRKYAKgBnWKmp
    aeson-2.1.2.1-JD8QPsoBF4NC1qVY6ch6us base-4.17.2.1
    base64-0.4.2.4-95SThkSzO4qJS32xX2OLhE
    blaze-html-0.9.2.0-DBNekIonl9ZHQcEIbEIyEL
    blaze-markup-0.8.3.0-5kCUxopfmLw19aMzBuNGN4 bytestring-0.11.5.3
    case-insensitive-1.2.1.0-LsX0nU5KPAoJUeisZm5xEf
    clientsession-0.9.3.0-LSvvSexRICqCWFlkqM7ENF
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-5zFQSWi5xEVBAmxL35th12
    conduit-extra-1.3.8-2EsBQsoEduiH5aGwZEbZVD containers-0.6.7
    data-default-0.7.1.2-8yRIq8kwMNHG7OFJsT5Ayy directory-1.3.7.1
    extra-1.7.16-1RhoiOXPfr67YmwKq5VFCS filepath-1.4.2.2
    githash-0.1.6.3-C6MrqT4Evvp6X4bLsqJtMk
    hjsmin-0.2.1-fmjLVjO0JYC3TaDz7uRfa
    hledger-1.40-L4tVwuvGVDmCwI7bsskot8
    hledger-lib-1.40-5YPQopR3JhhHgIF51AJJMw
    hspec-2.11.0-CSR0phsx7ZQKOBVMSbfouE
    http-client-0.7.19-IOiFZdMrMxf1FD0Q8GvNdl
    http-conduit-2.3.9.1-FP2JCCSsfhQ1fNIoAuOJFp
    http-types-0.12.4-BvZSYA7IliCW0EQtF31VI
    megaparsec-9.7.0-2LveF0uKMovFZzLupvHuy3 mtl-2.2.2
    network-3.1.4.0-IWANZy3yTdDGDiy7NHyKoQ
    safe-0.3.21-9VHQIWglBzGFIkoEOx5WCO
    shakespeare-2.1.4-Dnanl5d0sWAD8jUS2DDE5V template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-9HzsqtSzPkh2Dunn9NmEMr
    unordered-containers-0.2.20-ASGEyX3xTBf3ZK5sYSGlF8
    utf8-string-1.0.2-FAQSGuIUGqDKZx6mH04y15
    wai-3.2.4-9ouRC0VqvifDMOi7kU9fdU
    wai-cors-0.2.7-F7hkJgNAQx3BIKLPMlhdb3
    wai-extra-3.1.17-8ibmlHiRh9ZHcEXjBa7mIp
    wai-handler-launch-3.0.3.1-5XsS4bW90LeKHfsikMfbu5
    warp-3.3.30-6ekQ3avvbuT5j5432YK3Fy
    yaml-0.11.11.2-37tw4FuYjIR6RRod391CFN
    yesod-1.6.2.1-GbVhQAhFKRQDueLrvjXuPy
    yesod-core-1.6.27.1-Ltd2Iw7lYklD0zMvFlIvmS
    yesod-form-1.7.9-9W8orfVMeXp4leXvIcytjK
    yesod-static-1.6.1.0-EilQl4caXK2KuKlImS3BHi
    yesod-test-1.6.23-8OAqFFMT7vhHJu77DYIj34

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

