#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.40
visibility:           public
id:                   hledger-web-1.40-7H6QkIXUwZHBCLGAz5dkOC
key:                  hledger-web-1.40-7H6QkIXUwZHBCLGAz5dkOC
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  e680414189448d77001f98e34c8a6ebf
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.40-7H6QkIXUwZHBCLGAz5dkOC
depends:
    Decimal-0.5.2-7HkcHnHuSX5Je1AQdGwDRf
    aeson-2.1.2.1-2383fjET7FWJSHJW4VQuW base-4.17.2.1
    base64-0.4.2.4-H0MpAS0TkPZKOLYqjhkLLb
    blaze-html-0.9.2.0-JcISFZyc75x1w6gURdo9IX
    blaze-markup-0.8.3.0-2DVevyAmVI6DWWGE4G0qSR bytestring-0.11.5.3
    case-insensitive-1.2.1.0-L5gSnJGPP5IIfg5Ct42zAo
    clientsession-0.9.3.0-Io6Szez6MUt5tIwjjFUtGD
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-KngnZK76tgfFFxoV5CBnAq
    conduit-extra-1.3.8-3MmKPDiWyuY7jVYKoSUOkF containers-0.6.7
    data-default-0.7.1.2-8yRIq8kwMNHG7OFJsT5Ayy directory-1.3.7.1
    extra-1.7.16-1dxi8YUif1IEri9GoooCcr filepath-1.4.2.2
    githash-0.1.6.3-8p2dyBfw224LS8k9E3SN4
    hjsmin-0.2.1-CJk4CVF4UyZIemoyycrpeF
    hledger-1.40-FCeHzjkdnoNBHbLOyHME7O
    hledger-lib-1.40-CjOqAzdhXl85JvRE7DqN4
    hspec-2.11.0-LlNPYPCCjD3B32dA5x36VD
    http-client-0.7.19-L1utxVEiLaAGw6Jin0pjGQ
    http-conduit-2.3.9.1-ELIzfrfN67xHYB6OkkMeVz
    http-types-0.12.4-J468GPAKalzFHPyn7Dxh3c
    megaparsec-9.7.0-ATLDnW2l6g3Lq6818qHsE4 mtl-2.2.2
    network-3.1.4.0-AsoxBmMP1pfJSzv0IgKvnl
    safe-0.3.21-BDeWrSgar9b2azUh8fJqoI
    shakespeare-2.1.4-Ffug2c4FBRHEypPQwrIlcC template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-ISYORPhqblp3hlkoU2fe45
    unordered-containers-0.2.20-AeV3HTkHtCc6BQ9fzLSSB8
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-9Kksr2P6n2618XIJvAeWn8
    wai-cors-0.2.7-UdEIerj4JC56dZHPKg7Na
    wai-extra-3.1.17-DbbspRqBNn1Hu4DLX8i4Mp
    wai-handler-launch-3.0.3.1-KVoMfQljIrZ2hu8HhJHGLE
    warp-3.3.30-Lffo76YbSESHPABPHs3Lg6
    yaml-0.11.11.2-Gy58PaefZ5FFC7K5wkouMd
    yesod-1.6.2.1-2NeEl7JZi7C9kNL0NuXgKo
    yesod-core-1.6.27.1-GNPlyEXjziV5Qk3e6SPURR
    yesod-form-1.7.9-L4LW3HhM4IG5ENsEbH1XM7
    yesod-static-1.6.1.0-l1jYfdMKtXHr3SCuEXhMc
    yesod-test-1.6.23-CTH6UtL7UK18zTA58y5XnY

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

