#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.40
visibility:           public
id:                   hledger-web-1.40-ENE1otwuXU3YiNKlQf2mL
key:                  hledger-web-1.40-ENE1otwuXU3YiNKlQf2mL
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  6ec67d83c742f000252a657df01812d0
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.40-ENE1otwuXU3YiNKlQf2mL
depends:
    Decimal-0.5.2-3GgHvvTS1LYHyLdCFa3RYc
    aeson-2.1.2.1-KxhFBZPQYXiG3TO3nhA4Kq base-4.17.2.1
    base64-0.4.2.4-Huq4PAtjfjDDGxqDymCICB
    blaze-html-0.9.2.0-JvWO5U1ZqnhKpJxukwWjlC
    blaze-markup-0.8.3.0-96FxIJlNiUTLmGpH7K7eet bytestring-0.11.5.3
    case-insensitive-1.2.1.0-HQ3spM7mAjfDZxqIURCldM
    clientsession-0.9.3.0-F1NVPPguGGK5gfclNgP7KQ
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-KIgc8u8jbkN2A9El9r6mby
    conduit-extra-1.3.8-7AsukhXAhG9EP9Xj5iNAEL containers-0.6.7
    data-default-0.7.1.2-8yRIq8kwMNHG7OFJsT5Ayy directory-1.3.7.1
    extra-1.7.16-4SvI72pYgfdBRotMZ3tf9z filepath-1.4.2.2
    githash-0.1.6.3-1ssF2k1ghtsIF5ldbExMyD
    hjsmin-0.2.1-JRGDRiF1pcgwWuL8mRluF
    hledger-1.40-8wEPlhw93eeAsMVmTBUO4L
    hledger-lib-1.40-BTIRdD8PFsh5cRdRdHgKij
    hspec-2.11.0-KMeCyPXNLcx497UDdZVCwx
    http-client-0.7.19-5xqtlAuv10Ciu8xvmO6iF
    http-conduit-2.3.9.1-GnLewiLzzRNIX5AyUGzEKb
    http-types-0.12.4-CNeaCV6lRlPBtRvYIfwzr8
    megaparsec-9.7.0-Hsn4IAkVRB2A2QgsJUzrvG mtl-2.2.2
    network-3.1.4.0-ItBhIFDvz12FCCKfYobIMX
    safe-0.3.21-KJlW7jRgZb73RD220AjTnZ
    shakespeare-2.1.4-KlVyuQQZS2TKdozCHBI993 template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-IVg4e2FKApqEytJ5iwZzXw
    unordered-containers-0.2.20-Ee1qJYwM3Cx9FXWFU8Ujy3
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-2VO7o9HY8WS1nzOTcXJ5xe
    wai-cors-0.2.7-Lgh90RAffiIXYcMRQaIjB
    wai-extra-3.1.17-FcJEaDf2sTd8sAJeZ8Ojih
    wai-handler-launch-3.0.3.1-2gMq4u4gvW1KuDKL7ykN9u
    warp-3.3.30-3JEZ0a05SZmI3HRpzfc3JW
    yaml-0.11.11.2-L2X3cWpQNlfIqZcLiuVQFe
    yesod-1.6.2.1-5YlfPoGh7BiJi6n1t2QShh
    yesod-core-1.6.27.1-mhg8agwSjACb7loHO0h8p
    yesod-form-1.7.9-6F2HuB9qGctLMG6sEiwIv0
    yesod-static-1.6.1.0-GOvqyRwfLwoJ9vaVF63OSO
    yesod-test-1.6.23-4Aa86ZqQgvf26rRkPLcWjx

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

