#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.40
visibility:           public
id:                   hledger-web-1.40-99jTCZbvMaN9MZT91KPWhN
key:                  hledger-web-1.40-99jTCZbvMaN9MZT91KPWhN
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  09f3522fb290d584f8294e690c3cbb09
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.40-99jTCZbvMaN9MZT91KPWhN
depends:
    Decimal-0.5.2-JecesaLH4RB2M9nkzEdh9r
    aeson-2.1.2.1-7goQjQKasWuq7oOasot83 base-4.17.2.1
    base64-0.4.2.4-BFSMvxKoTHgL9DQ0ds76dp
    blaze-html-0.9.2.0-K8M4IXmnpCY52d5b9W0uq7
    blaze-markup-0.8.3.0-Hw82R3dN1AH6upDgw0RHOk bytestring-0.11.5.3
    case-insensitive-1.2.1.0-K9RqmTXohzcArWLcYT3z8C
    clientsession-0.9.3.0-2MsXSl3m9Vo8ZIeezLq2BN
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-GExfIrooWL7LwgSGxPA8ji
    conduit-extra-1.3.8-AVgKJR92sPqHTsKlHZaS3 containers-0.6.7
    data-default-0.7.1.2-7c115eFpvxq7Z5z0er1qPt directory-1.3.7.1
    extra-1.7.16-80ecfHnnghTBG7BFI6ZuEu filepath-1.4.2.2
    githash-0.1.6.3-J2nSnk9GDaPFxHSmFMiscc
    hjsmin-0.2.1-22Yjdggyufa5im5YyY9Shu
    hledger-1.40-1hqDvdF1VaL3gC1w7VkXyS
    hledger-lib-1.40-AdyA1mJO8N76vfPnW5YbXy
    hspec-2.10.10-BMr0WgLciUoJy1wbXgE1cv
    http-client-0.7.18-CnXCdYMBeS1GdWldzgGjBw
    http-conduit-2.3.9.1-EGznccxfxxcCePRqW08Zns
    http-types-0.12.4-IhtLMXP6VlH4EvGJYn8uz7
    megaparsec-9.6.1-Bx9HL7OUnKeEbRFabqUOjM mtl-2.2.2
    network-3.1.4.0-JHT56NFIotXJvLJoz7gUbr
    safe-0.3.21-8mpzNcEczf72ex32A7QfCP
    shakespeare-2.1.3-VIfs5X4agoEHzM5LEBqg2 template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4-3SBsXwUhhAM1AlokChSoJS
    unordered-containers-0.2.20-5ChD9TF8iAH5uLARI0QLMz
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-EOBJdwgqwP2ZRndhZ2MHb
    wai-cors-0.2.7-AXEwMTW1q2kIz1ePWz7aZ0
    wai-extra-3.1.17-5OlmeccVguC52S60ISVTO1
    wai-handler-launch-3.0.3.1-DW2gGnAuCHI5bJlZs8HC6r
    warp-3.3.30-7E53fKdVIp56CZqGjn81a9
    yaml-0.11.11.2-2W7z27CjpasExSCBUzhQZU
    yesod-1.6.2.1-3v215lkGuiP2qhYPQF7AVU
    yesod-core-1.6.27.1-FGipcORE225Hil8iLY6vT
    yesod-form-1.7.9-BNTdhcs2WuU7v0v5DjRU5Q
    yesod-static-1.6.1.0-5nV5yiHH8Lx8YmG972NG0H
    yesod-test-1.6.23-4d9njZN26eL31WKZxnvfYE

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

