#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.40
visibility:           public
id:                   hledger-web-1.40-5fi0W3PenT2GYjN4Gd7AEZ
key:                  hledger-web-1.40-5fi0W3PenT2GYjN4Gd7AEZ
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  5953fbbd0105f290f76aad42305c03d0
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.40-5fi0W3PenT2GYjN4Gd7AEZ
depends:
    Decimal-0.5.2-APQVLfL2lfDLsMd1mZxJBm
    aeson-2.1.2.1-8kv8xeVfmZaCzdZG9aqfKb base-4.17.2.1
    base64-0.4.2.4-9oAZ9f4YtT6AwWA615SrET
    blaze-html-0.9.2.0-IQy0cbBKAdFK1dhx28dN3E
    blaze-markup-0.8.3.0-4hwy5FvfefH4SRocIWu2JE bytestring-0.11.5.3
    case-insensitive-1.2.1.0-KEDJwVxaVqqI97A4XPwej0
    clientsession-0.9.3.0-LI2GpetUnVqLvWksM2ERgL
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-He7eBVLUt4xGGZqD48fwnz
    conduit-extra-1.3.8-FPYZ2SHai5SFHdZmLa2NAW containers-0.6.7
    data-default-0.7.1.2-8yRIq8kwMNHG7OFJsT5Ayy directory-1.3.7.1
    extra-1.7.16-5K8PvZO4Jh1LEHVlaJYF8M filepath-1.4.2.2
    githash-0.1.6.3-JMiDEK0t2zdG2ZIJUOLa7N
    hjsmin-0.2.1-73EO2GUBi7DQFwPzizJAp
    hledger-1.40-73Y09ijakav6Unp0IS0et0
    hledger-lib-1.40-HMU4nPrctrOK9elwq5XKvy
    hspec-2.11.0-D7VULxXcWAEGlCKVY5WpWR
    http-client-0.7.19-4PBxl7ykGvY1A1M3m4syiA
    http-conduit-2.3.9.1-Htpo5ybm1VnLc22xTZEyI8
    http-types-0.12.4-5NSSMgOt7vT4e8131JaEsZ
    megaparsec-9.7.0-1voytdgo3wjFoCwR6CT9gz mtl-2.2.2
    network-3.1.4.0-HNOpCulLIRrH0UV3cvGeTA
    safe-0.3.21-EJlQ7Hm9gwUGpRoyGimKjN
    shakespeare-2.1.3-K5a6sFLzi5AHuw2m9zagxp template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4-DNtjNiox36vAutr9B2n0Bm
    unordered-containers-0.2.20-IhcdMC6aki1KSQ4zttUKBR
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-IYJEpaLCFRy2DnKDSvDPLZ
    wai-cors-0.2.7-9UOH4d0qihF7uQXLafvPzR
    wai-extra-3.1.17-34UEZRXaQ4Z4guZCTy0CSv
    wai-handler-launch-3.0.3.1-51R2DrJABJVDrviO3QZjGn
    warp-3.3.30-GlvU5xpqkS70ZBvoUTEZJ
    yaml-0.11.11.2-4YdJa1QWN5D2q5QU4cZScS
    yesod-1.6.2.1-CYPCiM5xxUNH3DS5ibnAly
    yesod-core-1.6.27.1-4K8BTLNM7DCDe4NER0WoPT
    yesod-form-1.7.9-Krpg0eMggSeEmma6VLG8vO
    yesod-static-1.6.1.0-Iz39A3xWMZaGUl1ugqmUIs
    yesod-test-1.6.23-DFjYEFMB8h02NQ91hjUpB0

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

