#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.40
visibility:           public
id:                   hledger-web-1.40-2x1BuxcRwZB8vyU8F6N2fX
key:                  hledger-web-1.40-2x1BuxcRwZB8vyU8F6N2fX
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  1935af795f91cb644181fb76bdff8b1c
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.40-2x1BuxcRwZB8vyU8F6N2fX
depends:
    Decimal-0.5.2-AZ1DirwOuA1Dolz0PpJdzZ
    aeson-2.1.2.1-6q2KNYwRaL29rPm6MMaiUC base-4.17.2.1
    base64-0.4.2.4-KzAUIdpVFoN2UKJDRkXHn8
    blaze-html-0.9.2.0-Dqz1hSF3Pl41AMAbxwq4Fa
    blaze-markup-0.8.3.0-DSAl5fl5qavBMEF3Zc5OIF bytestring-0.11.5.3
    case-insensitive-1.2.1.0-fOfWi0N5mt64FY3ZUEjlf
    clientsession-0.9.3.0-EruVxjsJQpywi3a3cu9Hk
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-5V2PSjSHeYS5sF2XpXfdrm
    conduit-extra-1.3.8-AFR5r0hqxtKmjLH3pCwC0 containers-0.6.7
    data-default-0.7.1.2-8yRIq8kwMNHG7OFJsT5Ayy directory-1.3.7.1
    extra-1.7.16-3MpJB5o0ESB1pjz4ZT9XVu filepath-1.4.2.2
    githash-0.1.6.3-9Ub3iO8mezZEDyqnsfb7Ym
    hjsmin-0.2.1-2ejPksHit3O2HSpmY5O6YC
    hledger-1.40-3YiJOuOWXH471GljCelvo2
    hledger-lib-1.40-Eb53cvaN8WCost1kVbvEJ
    hspec-2.11.0-2HqzJYra6fZAMc88T9PMYG
    http-client-0.7.19-2XRSbtk4hrv80aqsDMrhLG
    http-conduit-2.3.9.1-4fJpFUSyBe2kREJOIVncV
    http-types-0.12.4-DI0pM0gIACkLbu0K6LN6Y6
    megaparsec-9.7.0-9KX7uZoGWhIHAGHTH7OWSU mtl-2.2.2
    network-3.1.4.0-1Bok7DDOmdQ7OlyZLPDJ7H
    safe-0.3.21-85eF7qPff6wBGTusoDGORM
    shakespeare-2.1.3-LfEVIncrchJ2i1LBCpCzBy template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4-F45C0yQb72PB0noYxmBbjG
    unordered-containers-0.2.20-3NcLl7S6t7kAuh7l4Ieeoo
    utf8-string-1.0.2-FAQSGuIUGqDKZx6mH04y15
    wai-3.2.4-3rFOvZ8NgHlICB5dLUJnHJ
    wai-cors-0.2.7-CTIFSUkb32w1oDWH7Pe7XG
    wai-extra-3.1.17-90f00E6MyEx2gZnYlOGtEN
    wai-handler-launch-3.0.3.1-Cyu6WWqSdKIGIbaNBJtnz9
    warp-3.3.30-KAktcEKH8PzKpPkMeOiB8Q
    yaml-0.11.11.2-5F2HGIlw8EgCf97SYdnZLa
    yesod-1.6.2.1-47vLLYwK9zaGL98SzUyRj9
    yesod-core-1.6.27.1-FMDBX9C7gU0IV5ZGAWb4yf
    yesod-form-1.7.9-80pt6D5zh6A1lyZG1gq045
    yesod-static-1.6.1.0-B9X7wtHHR2GJdGoSTfWV09
    yesod-test-1.6.23-HVvWm5xN4EXFX0nj8D2cds

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

