#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.40
visibility:           public
id:                   hledger-web-1.40-9KrTB6H2qleIeMYoJ1EGK0
key:                  hledger-web-1.40-9KrTB6H2qleIeMYoJ1EGK0
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  3ee8f5e385af76284d0e1071b3cf00c9
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.40-9KrTB6H2qleIeMYoJ1EGK0
depends:
    Decimal-0.5.2-AKzthhCU5gG7f9djUfMNxW
    aeson-2.1.2.1-4XssoWP8s0tKPHSv4bO4jS base-4.17.2.1
    base64-0.4.2.4-9YM983Uy5uZ3ye4o98WYb6
    blaze-html-0.9.2.0-6qRmvU75P7Y4rwuconQelG
    blaze-markup-0.8.3.0-HOvk3sClrAvE2E2UKocwxZ bytestring-0.11.5.3
    case-insensitive-1.2.1.0-DJzIJZH4DdL5KuISGpY4ML
    clientsession-0.9.3.0-Kzun0D0ezTUv8e1P7GjC1
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-106afLHctvQ8RMVwlIAuXV
    conduit-extra-1.3.8-H8VbVpHwFEnEcdjiRo0ORI containers-0.6.7
    data-default-0.7.1.2-8yRIq8kwMNHG7OFJsT5Ayy directory-1.3.7.1
    extra-1.7.16-FilKm1JQPfHLr5IAgySohi filepath-1.4.2.2
    githash-0.1.6.3-Jif88qBxw2QBDvDs7Q0Zx3
    hjsmin-0.2.1-7mviT0mwVaMI7lu71YfK56
    hledger-1.40-434hFDscb8fBeViEM78zAw
    hledger-lib-1.40-8jrFUPTkgcs1tHEGIuW8Go
    hspec-2.11.0-GdULNfIjwTK3r573uKLMe3
    http-client-0.7.19-7a4jmx6GqRn5GICVB644F0
    http-conduit-2.3.9.1-EsbQViE5oYG6OdIa009kue
    http-types-0.12.4-2RoTdpR4Maj5iH1GQnMeig
    megaparsec-9.7.0-41F5K5g8jfX9jzQ5gGX83m mtl-2.2.2
    network-3.1.4.0-5uK3u4RW2BBBzIyfRS5Jps
    safe-0.3.21-Fk6FaHWaShq6V6AQNbWYhR
    shakespeare-2.1.3-AktWEFGoRDbKMnUQqifRLM template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4-EMY80kE8QWvCO803nZuJ6g
    unordered-containers-0.2.20-3371VA61Be1CojVrkG24uM
    utf8-string-1.0.2-FAQSGuIUGqDKZx6mH04y15
    wai-3.2.4-FUHxhH9mDYMACC6LG7bc57
    wai-cors-0.2.7-IWaAcAyNlD93P8GXWYaRZQ
    wai-extra-3.1.17-F37Uz7dHy2j8W9NfORn2rV
    wai-handler-launch-3.0.3.1-7E74EWIG2J1IgdwiJgfZN3
    warp-3.3.30-1ABydamOwnOA3Rbg2BzTMd
    yaml-0.11.11.2-KMaHaCh4T6S1pXHm7ZoiOh
    yesod-1.6.2.1-aMJWQTkGyQ9jqrZElClgC
    yesod-core-1.6.27.1-Je5Rdxu2jxwEMdpzOWi3xQ
    yesod-form-1.7.9-4QJ6VxJTD8cAolOtn2Jql4
    yesod-static-1.6.1.0-89dZfXUNxX3K2E0SLhuyPc
    yesod-test-1.6.23-CPLU9dW69UVAZ4gFjWu2oh

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

