#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.40
visibility:           public
id:                   hledger-web-1.40-JaEawrd1SUIJ80bvS0ULye
key:                  hledger-web-1.40-JaEawrd1SUIJ80bvS0ULye
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  047135f06c446ec63363be2407e380f0
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.40-JaEawrd1SUIJ80bvS0ULye
depends:
    Decimal-0.5.2-AmxrYKF6eEd399LgGvC3L2
    aeson-2.1.2.1-LDc25PpdH5WHlLB8Mcp2Rh base-4.17.2.1
    base64-0.4.2.4-2HooVKRlrrvBGrcDUm8ctG
    blaze-html-0.9.2.0-FWwbx2kwK4a9cGj7dIEiyC
    blaze-markup-0.8.3.0-LhctOnkfqfP7twZcowViz5 bytestring-0.11.5.3
    case-insensitive-1.2.1.0-1RHeXy1S6Rm5Spie3OUbmD
    clientsession-0.9.3.0-GqaUMs7Ya1nAoGTmYuqwr3
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-B7V1OlOMAuaARuDzpB8NsU
    conduit-extra-1.3.8-HPIe52rZrj4DPVo2Z9t0LA containers-0.6.7
    data-default-0.7.1.2-8yRIq8kwMNHG7OFJsT5Ayy directory-1.3.7.1
    extra-1.7.16-EVqIvjfjup2KjWh1SyzBng filepath-1.4.2.2
    githash-0.1.6.3-HmqZIPTawV368mHir3XT8u
    hjsmin-0.2.1-A2ubGxc7wMM6JBY9GNU4aD
    hledger-1.40-1tgky5pinib5iKy0CsbDdz
    hledger-lib-1.40-1Xl7je7PL8z3tpRvMVEZTK
    hspec-2.11.0-7syuManRaN72bsa5yGO3BC
    http-client-0.7.19-HKufh1jjwuP9GgoT1daAYk
    http-conduit-2.3.9.1-H6NXeShDOM53I77DK4Tqij
    http-types-0.12.4-AKSPjJIqePQLPw819bUb23
    megaparsec-9.7.0-AMbJQB9BzBxf81g5ZS6Op mtl-2.2.2
    network-3.1.4.0-L5Z9Li45X29DmnCadSsbZW
    safe-0.3.21-4A1yMugax9JCQWzW2mE78Z
    shakespeare-2.1.3-GXia45KV4K5AqDlFAccbVH template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4-BDNMqGtORWv1TblmXvfCQe
    unordered-containers-0.2.20-Cw2Ec4BgC4sInKE4e5RLSk
    utf8-string-1.0.2-FAQSGuIUGqDKZx6mH04y15
    wai-3.2.4-5NCCbE2MlhR8uTC9MRfmrk
    wai-cors-0.2.7-9BK8bKq5Liz6thVT45VPEg
    wai-extra-3.1.17-GxD8yd34eL3CJXZz7xIhMh
    wai-handler-launch-3.0.3.1-FIHDJ8bR4CzBvw8EKYTGjg
    warp-3.3.30-yQgzpV7zRBGIgcxEF5wSw
    yaml-0.11.11.2-6CFelqwv9D52jRp9lrWsa8
    yesod-1.6.2.1-2mcts2KhLcDTRpum5FQrf
    yesod-core-1.6.27.1-4Hr7oQkmjlT1GtzxH5kkIs
    yesod-form-1.7.9-6M8I63scSjnC6908WarJn7
    yesod-static-1.6.1.0-HiPjsXKs32lBXcsZyBxFpy
    yesod-test-1.6.23-9mzdUgpw0vnIeu48gH6sIp

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

