#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.34
visibility:           public
id:                   hledger-web-1.34-DoF2kkJTu1xDTpEMsaNQrl
key:                  hledger-web-1.34-DoF2kkJTu1xDTpEMsaNQrl
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  4100fee40ca7811056823bcb07a0bbc5
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.34
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.34
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.34
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.34-DoF2kkJTu1xDTpEMsaNQrl
depends:
    Decimal-0.5.2-3ov4NECoNfn4MtJW6ZyWTp
    aeson-2.1.2.1-HPwo2VO3hzcFr4fiGB5Oro base-4.17.2.1
    base64-0.4.2.4-GVixUHY35qBFC6DrfwVDEx
    blaze-html-0.9.2.0-HIsrFdX7DIkeeC0HU7u92
    blaze-markup-0.8.3.0-5mq9ryWS59iKdKRZ7SDBZd bytestring-0.11.5.3
    case-insensitive-1.2.1.0-1ILAtZHAjAqgINNQwApUo
    clientsession-0.9.3.0-FThQErNyQK7C9KgRijJYvv
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-CuuvisR1uAaJsPmK0tVtaN
    conduit-extra-1.3.8-BcW7Hf7I2YE6crDjGlMLQy containers-0.6.7
    data-default-0.7.1.2-7c115eFpvxq7Z5z0er1qPt directory-1.3.7.1
    extra-1.7.16-6O0vpR35xmz4TsZbH7SN4x filepath-1.4.2.2
    githash-0.1.6.3-c1isNu4ewp8fEXTGdHTRd
    hjsmin-0.2.1-Ht7WRvZeGxs9vHimQKKkSZ
    hledger-1.34-19owK1zKiZrFAKHnSbhMwd
    hledger-lib-1.34-3reSaXf5QNl85MVQ9r7kFV
    hspec-2.10.10-ELmZqpmmMLvY6tR5yEZxU
    http-client-0.7.18-IROMjfUUOqe2MZRLGJEp23
    http-conduit-2.3.9.1-8ZSYbeY1bnMDny60qnjvfE
    http-types-0.12.4-B5DxmOwiWvxHN2hLvYjsdc
    megaparsec-9.6.1-EACNQE4V0s4sorPNkNSJS mtl-2.2.2
    network-3.1.4.0-KV3OkCyx0pcI1DdyD3ZbeB
    safe-0.3.21-A7lw0NQn6dP12vgshNzPEt
    shakespeare-2.1.3-LPXWyq6PuWMARTXyi2Wiu8 template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4-3zZqh7W5xPMF9DzEJo8QhX
    unordered-containers-0.2.20-FFF0GulGLFtAHq6N1Lkm0s
    utf8-string-1.0.2-LQzUWC2hIN17FDKHsw4I2c
    wai-3.2.4-9jkCTz3VUjM6XVKXhFmJSz
    wai-cors-0.2.7-YKVE0yPHyG93MIobr9pRC
    wai-extra-3.1.17-JenvNP4A5oEBbk83XAPJeH
    wai-handler-launch-3.0.3.1-9Yo9TcaeFQeHMgIQkvsbPW
    warp-3.3.30-KG7ckjPPkJoBng0y4YFeAf
    yaml-0.11.11.2-Js6LFNiGnvSCwcyKNsoqtw
    yesod-1.6.2.1-50vPme5RjRWC44pB0XDT1f
    yesod-core-1.6.27.1-CTAqz8wn3GrFegVCBU6vsf
    yesod-form-1.7.9-6qYezOQdODS6ongdjz7k1x
    yesod-static-1.6.1.0-FZh1Cp99GAFJcJdqzCexxM
    yesod-test-1.6.23-8V0b2Ecuau07lgrKj5H9gK

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

