#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.34
visibility:           public
id:                   hledger-web-1.34-GQA63IMmhQELVdhZdiojCG
key:                  hledger-web-1.34-GQA63IMmhQELVdhZdiojCG
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  b9e9b54512e9556af0dc7d592f48916e
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.34
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.34
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.34
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.34-GQA63IMmhQELVdhZdiojCG
depends:
    Decimal-0.5.2-LsPDLIrOkiFBdgUnFtbVMh
    aeson-2.1.2.1-2ooOAwlErgbHj6Tyvuh2I5 base-4.17.2.1
    base64-0.4.2.4-ESSFghzIm5y8z9839dFyrI
    blaze-html-0.9.2.0-IKVhdom3eJ46byuPgdmCPo
    blaze-markup-0.8.3.0-43ndMyx4AoQ9NdwqsN7MSJ bytestring-0.11.5.3
    case-insensitive-1.2.1.0-JUsvO4q6QZv9oNQva346P6
    clientsession-0.9.3.0-3fCGf259mcYLLb1yWvNhWA
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-IWWL48tOiUMKLUHQSWumck
    conduit-extra-1.3.8-BYn4ndKCbWC3YxWBUq3JmF containers-0.6.7
    data-default-0.7.1.2-86VyjkfSCk63mGj7Z05i2D directory-1.3.7.1
    extra-1.7.16-EE4Fm9GViTg3pd8NcKHvhw filepath-1.4.2.2
    githash-0.1.6.3-DWqYHMR0B9Z7LNUWgB0B63
    hjsmin-0.2.1-FL996LnS3GeDhvH9ioiC90
    hledger-1.34-KZXroK2oTTFRe4AEz40RQ
    hledger-lib-1.34-KYJLKMV6SZQ1dnDJa6eMQ6
    hspec-2.10.10-4hshClf7m0IIR9RVkS3XPo
    http-client-0.7.18-LbIjfqgkVH6EQZrPuBb65p
    http-conduit-2.3.9.1-CDH4stm4rFa20hUCZ1EiF8
    http-types-0.12.4-8FTU05okzyoIwQtiG4S4B5
    megaparsec-9.6.1-5RuoB8ePxKF1XTFOu32khO mtl-2.2.2
    network-3.1.4.0-CjG4q0LIF56BxDJPM1CXeZ
    safe-0.3.21-Gdh5UH2UDnXFnFRoHdwbNc
    shakespeare-2.1.3-Jr7HERzylqABop8C1hWBNO template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4-HSgadBBXSpB6KNshGA8sWV
    unordered-containers-0.2.20-5aRSzj1YCHv4h2N6lFa6Hx
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-L2MKgLVnviY4s0S5pdTKWL
    wai-cors-0.2.7-FvUaYS4TN4SDI7d2pnmpZ8
    wai-extra-3.1.17-46o2GcAEiOm75KbmeB8K8g
    wai-handler-launch-3.0.3.1-KHzv8NOpFBT6PHcAp4gNfE
    warp-3.3.30-Fqlxus0f3AVFkHNGiHng9R
    yaml-0.11.11.2-5dcPsDqTmiN4GQIaTwmCAS
    yesod-1.6.2.1-K9MaeMZvooRKVNMsErdZ1b
    yesod-core-1.6.27.1-KjARCE7Ci87F1njRmvAPTZ
    yesod-form-1.7.9-5yTkziNPhsTJL85qqoAuEz
    yesod-static-1.6.1.0-D8atGtLkZ58Giq9KsPgHym
    yesod-test-1.6.23-CFAV7lDqwXy238RjgWJky3

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

