#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.34
visibility:           public
id:                   hledger-web-1.34-C9WVnqQsBC65oC1xih1Li4
key:                  hledger-web-1.34-C9WVnqQsBC65oC1xih1Li4
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  a65b8df8e38a6ad95006e5ee1ccc91f0
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.34
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.34
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.34
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.34-C9WVnqQsBC65oC1xih1Li4
depends:
    Decimal-0.5.2-BNb9YCHVG2C60ze0TOBA5o
    aeson-2.1.2.1-HUj8Ou2Jrr19darX8iyQt4 base-4.17.2.1
    base64-0.4.2.4-LVD59VYGMT8KJu6guyUNNy
    blaze-html-0.9.2.0-9ouvNI0LGvR8T2YDANh957
    blaze-markup-0.8.3.0-H4QAcgAuzx9AWvBQPdzmLl bytestring-0.11.5.3
    case-insensitive-1.2.1.0-JGcld4v8YDLG9iCNMxqnvW
    clientsession-0.9.3.0-JiIZeU7owwpI7cbRTECVhs
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-2lml8TYLrSoCJWeVqTIcf8
    conduit-extra-1.3.8-FOWZ5xxlIhQAwh6RwRPJbV containers-0.6.7
    data-default-0.7.1.2-8zpNuXeugnsCXhsU9L7wsy directory-1.3.7.1
    extra-1.7.16-HFVkAG9ZjF7KRVgcoT9Nb3 filepath-1.4.2.2
    githash-0.1.6.3-11jnrk28U0G11QUnE5ZUS
    hjsmin-0.2.1-Brn8ARAXLu9JLB8kY11IbK
    hledger-1.34-65UvDhMgngq2OhSauVOs1T
    hledger-lib-1.34-91Zttm2rnTS2DGBKS5jMIw
    hspec-2.10.10-GyJM8BJFoXsHtSMSZnGHhJ
    http-client-0.7.18-1ilMUdfjVEzBmOQGNnAaP8
    http-conduit-2.3.9.1-seK0P5M19ELsEDMgp2Oh2
    http-types-0.12.4-22ca4VB3NcX8GYX2Ium30U
    megaparsec-9.6.1-EEBj4pRLerNCeJDumClMn7 mtl-2.2.2
    network-3.1.4.0-9WwAYDZyp2nAB4XV6sI63l
    safe-0.3.21-LwDGcPt9fP72KP4K2XydmJ
    shakespeare-2.1.3-EV3osFU46sZ3RQsTfgulBH template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4-8PAyJFIzbO7LjuiJWjVyWo
    unordered-containers-0.2.20-obNV32ZSreHxgWRz6JrKP
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-EhNMiHqwqcPHb2wBYuWApz
    wai-cors-0.2.7-5BNiGbnX2rv9Yzon3ik0lS
    wai-extra-3.1.17-3xNX1ZolJZzLAaHT3vtCic
    wai-handler-launch-3.0.3.1-5aiP3yDDIP5Gpa4mtWzaUw
    warp-3.3.30-6dsmXQBSr389fuJ8uyb1EE
    yaml-0.11.11.2-17ksE1qZfJBIhW1Y2VX9Er
    yesod-1.6.2.1-HMPtaa8Y48oA08n7OuaMYO
    yesod-core-1.6.27.1-6rT6Bxwfg7f1GkDs7zSM2U
    yesod-form-1.7.9-14s9VOfSwvyKIkQ1gt3s6T
    yesod-static-1.6.1.0-9JlbX6ZDB4DLTMDXlyza2z
    yesod-test-1.6.23-LPYIclopnhlLJh4vbiNp4I

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

