#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.33.1
visibility:           public
id:                   hledger-web-1.33.1-E1UUkEFtkuwHU0GLWfkjeb
key:                  hledger-web-1.33.1-E1UUkEFtkuwHU0GLWfkjeb
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  98058a34ce3c2dce3af7701f55c018a6
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.33.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.33.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.33.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.33.1-E1UUkEFtkuwHU0GLWfkjeb
depends:
    Decimal-0.5.2-FxkNPhsZzXo2YJiBcl3tH0
    aeson-2.1.2.1-4cRYi3WcVwTKRqMhXUztfB base-4.17.2.1
    base64-0.4.2.4-92VpUMlgGao2kzzzPBkh4e
    blaze-html-0.9.2.0-3YZTlMAnllRFVmykcDevNv
    blaze-markup-0.8.3.0-LoFuvEUpMWsE3h8IrKFaX0 bytestring-0.11.5.3
    case-insensitive-1.2.1.0-EmvCHr7Pi0DF9aG5Som7hU
    clientsession-0.9.3.0-FoBQxKAe11bBMHB1UK6urG
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-KZNeLPeXvjD5EEhRbg4Ht8
    conduit-extra-1.3.8-Gwq2qlVhV3jEWryL83GuOP containers-0.6.7
    data-default-0.7.1.2-86VyjkfSCk63mGj7Z05i2D directory-1.3.7.1
    extra-1.7.16-A351zU6dpS39u0BZ3kHe7I filepath-1.4.2.2
    hjsmin-0.2.1-7ym19bT0q919P2tTD6rGwV
    hledger-1.33.1-4BMyf6m6775ejMLvDHIFv
    hledger-lib-1.33.1-AA22bbjRFv56eDSCybxe3u
    hspec-2.10.10-DfdXuKogMQ7HrNFlqwvlNF
    http-client-0.7.18-IsbH9OAm6XgF9hL4xsUtLO
    http-conduit-2.3.9.1-9XrH6XFvamFKUm5dYrHOKt
    http-types-0.12.4-Hz1QXcCML2nIj1GeZ6O8D8
    megaparsec-9.6.1-GErkrd4BuZw1o2z4Ja9YFU mtl-2.2.2
    network-3.1.4.0-2CDhKFQZ96O3njunkpEqT2
    safe-0.3.21-I6HqCqj5Wiu30StmjnRW6G
    shakespeare-2.1.3-AiRmHASTBMVL4BEor17vsU template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4-HkeMBjDm0rZC7ERiJ32kv5
    unordered-containers-0.2.20-A2tjqfQXDXnFd3Ae9FP0C3
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-Gif3XxAfqpyBhMnONwiLxO
    wai-cors-0.2.7-1dVUgK4Pnuga5TM0Uhn1U
    wai-extra-3.1.17-ICNUGZgrp9yCPmArX91jDJ
    wai-handler-launch-3.0.3.1-C3d7KY2cZBdBcyAaV2pp9h
    warp-3.3.30-3UqF2mGeTD0SwqE0bScco
    yaml-0.11.11.2-KD8ys2GTsv8BVG0mIbaE4l
    yesod-1.6.2.1-EG4mIPeN6vWKtnrTWV4M8u
    yesod-core-1.6.27.1-8qf2OxpghVk4QaGwAzC3Vj
    yesod-form-1.7.9-IVg67W7w41nGwysxwO60Js
    yesod-static-1.6.1.0-JLV5cFdOVZaJi1gDjePkWS
    yesod-test-1.6.23-8gbrh3fo5id60Ymu4GNAx6

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

