#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.33.1
visibility:           public
id:                   hledger-web-1.33.1-9qU9p2RE6B69PT5DQnJL1G
key:                  hledger-web-1.33.1-9qU9p2RE6B69PT5DQnJL1G
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  b65fbbfc270a1dbee1947d13a114bfc1
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.33.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.33.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.33.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.33.1-9qU9p2RE6B69PT5DQnJL1G
depends:
    Decimal-0.5.2-DTT4TEm4pOo4IzU0utV4L2
    aeson-2.1.2.1-HdmwuFbnNgF6PqutsUaf6Y base-4.17.2.1
    base64-0.4.2.4-3RP8bcwAvHQSNRvgPQQ6O
    blaze-html-0.9.2.0-Af5P3A2URAm8PEOIhy6b3k
    blaze-markup-0.8.3.0-Alr6JP17MQvDFN7aUk8LfK bytestring-0.11.5.3
    case-insensitive-1.2.1.0-Abd5Q51hq5G7EsMEex29Bt
    clientsession-0.9.3.0-6fsHS1O5PSxBhiIduq2knm
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-8TTHoZfFEcNByedkE9Rv7V
    conduit-extra-1.3.8-5tATRySgxkKGEeqgx2l5Qz containers-0.6.7
    data-default-0.7.1.2-6Zl8APX45CF9ONl13lbZ09 directory-1.3.7.1
    extra-1.7.16-EUr2jKVqwHnBVI5Jwc0wI7 filepath-1.4.2.2
    hjsmin-0.2.1-3DOtPVQkRnRJaWCYnYc4iU
    hledger-1.33.1-LCwbm11M3OKFui5tIqwuQB
    hledger-lib-1.33.1-7xcAKDMKg7f5I4ob4nT2em
    hspec-2.10.10-GABSAcS03JI8KBYWkKpU7p
    http-client-0.7.18-K1IvRTF7D2SE2xldIkW1tD
    http-conduit-2.3.9.1-6fXV2QE6NsMJEI9FcMco8M
    http-types-0.12.4-ERErpW4oIqaKIzWiLMLiFN
    megaparsec-9.6.1-5wqMRZqTk6B8Hn3YAbESf9 mtl-2.2.2
    network-3.1.4.0-L93bqt4J89t6uDPHvRPUpA
    safe-0.3.21-9QjteULaG8kEYP4tViLK83
    shakespeare-2.1.3-C4PzgEs43SJ2cv9Csuh3LC template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4-BZWTyxtN7nl3Z0fwlVJ8w5
    unordered-containers-0.2.20-DaOkK38PYRa9pF7ZwbG4ZB
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-4XAAckw9HTnIyst5cAezpH
    wai-cors-0.2.7-3ys6JD1KfGeLoPssO9Xhyo
    wai-extra-3.1.17-53XV29eB5n9H5kmds7FJvQ
    wai-handler-launch-3.0.3.1-8usC0rjEEnH9XbrqRnMFiI
    warp-3.3.30-1sM6lmV0MZX18rPjR7YNXZ
    yaml-0.11.11.2-GC1CtyXJHYx5kXLLIccvTD
    yesod-1.6.2.1-IUBq6t7Y2waxIBGu6xjdr
    yesod-core-1.6.27.1-5hnBS0Z2Jx2LBqBQo2mX3X
    yesod-form-1.7.9-LUa1guWiVP9JLAYUNHIzRz
    yesod-static-1.6.1.0-4iNcwaZyTfWY0gcKXTqSo
    yesod-test-1.6.23-6rnNueaZXasGf49s3N7j4C

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

