#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.33.1
visibility:           public
id:                   hledger-web-1.33.1-G5uUTvGnHDfJCfdI53zXJM
key:                  hledger-web-1.33.1-G5uUTvGnHDfJCfdI53zXJM
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  c5c9cacbe66f3158876aa46ec19dba9f
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.33.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.33.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.33.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.33.1-G5uUTvGnHDfJCfdI53zXJM
depends:
    Decimal-0.5.2-6swmwvqkmPSCVjz5gNR31f
    aeson-2.1.2.1-5gViDrHjeNhDfT19MwgeMT base-4.17.2.1
    base64-0.4.2.4-5W6jGptXMtR5tnsYFHtPPH
    blaze-html-0.9.2.0-1o80EWHMpY0BuGRIuRg92O
    blaze-markup-0.8.3.0-4zzXpVLD4d23Y4oP0TA1oB bytestring-0.11.5.3
    case-insensitive-1.2.1.0-D4Bx6jK2099tFJcppXDxv
    clientsession-0.9.3.0-4Bha0O5e8wZCvzT3IKNdht
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-FVLYIXkx9NyFPBDwnE2wvC
    conduit-extra-1.3.8-8pleVQgICEo36BRunaYlKV containers-0.6.7
    data-default-0.7.1.2-86VyjkfSCk63mGj7Z05i2D directory-1.3.7.1
    extra-1.7.16-HVhKnqmiqAP7qbJKi6sYXI filepath-1.4.2.2
    hjsmin-0.2.1-KAMUl3kgGhk9T8RLYrmqam
    hledger-1.33.1-LClX8TQf74Y8dIDvCq5WMl
    hledger-lib-1.33.1-BRnSz40dxZGA6QImjTi5wW
    hspec-2.10.10-Ktt0w7fmbwOKxkdSOilgkn
    http-client-0.7.18-F2vUdc4GuQE1q0cHPJLrjL
    http-conduit-2.3.9.1-ESJQakueNx1GkZUuLxkDV0
    http-types-0.12.4-845zQBf8K2R8QZqh3scBqV
    megaparsec-9.6.1-K842mSJotk3GLelhPtnPWL mtl-2.2.2
    network-3.1.4.0-EpGtkoqQTWdJPJAj8Thqiz
    safe-0.3.21-5rcOjzCJ9nx5zsTE32vvEc
    shakespeare-2.1.3-GoTg67v0qMu7Yk8hG19VVQ template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4-FtHhyYNKXNEEfGBWiva7Zs
    unordered-containers-0.2.20-BooESfmG3DbHMU6mBvbzIL
    utf8-string-1.0.2-EQXJBdOxi5qEemJFLwYYhw
    wai-3.2.4-41iNGcJSwNvEUgUKaMQRRA
    wai-cors-0.2.7-7gbHF418Wh2Ld3alANyM6K
    wai-extra-3.1.17-8nCNR940FkpGdBLxLOLRvO
    wai-handler-launch-3.0.3.1-Fxe9kHNh3BVCSNaFzbDXUk
    warp-3.3.30-KUCEwGn4TuyLVm9l2BLxF8
    yaml-0.11.11.2-2xyl6vgLYjLLxSjbPATLZ7
    yesod-1.6.2.1-4IaTPirHZpbKShgImcinuh
    yesod-core-1.6.27.1-4dPOXVEtJi3ATIF07NpRVD
    yesod-form-1.7.9-COYz10Q2Oy76sStqybtn43
    yesod-static-1.6.1.0-JIm7OhaDnE65mpSKOeV4YG
    yesod-test-1.6.23-DX8C5zqNaMS5aoU7A0Kbfu

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

