#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-iadd
version:              1.3.21
visibility:           public
id:                   hledger-iadd-1.3.21-5xkwo85jtYWAm9M90YNBVb
key:                  hledger-iadd-1.3.21-5xkwo85jtYWAm9M90YNBVb
license:              BSD-3-Clause
copyright:            2018 Hans-Peter Deifel
maintainer:           Hans-Peter Deifel <hpd@hpdeifel.de>
author:               Hans-Peter Deifel <hpd@hpdeifel.de>
homepage:             https://github.com/hpdeifel/hledger-iadd#readme
synopsis:             A terminal UI as drop-in replacement for hledger add
description:
    This is a terminal UI as drop-in replacement for hledger add.

    It improves in the following ways on hledger'\''s add command:

    * Interactive as-you-type completion for
    account names and descriptions with optional
    fuzzy matching.

    * Integrated calculator: Amounts can be written
    as simple sums with real-time feedback on the
    result.

    * All actions while entering a transaction can
    be undone

    * Configurable format for date input. Instead
    of @y\/m\/d@ it is also possible to use other
    formats like the german @d.m.y@.

category:             Finance, Console
abi:                  9a26b58031738a6877f5d05fbdc3fc97
exposed:              True
exposed-modules:
    AmountParser Brick.Widgets.BetterDialog Brick.Widgets.Border.Utils
    Brick.Widgets.CommentDialog Brick.Widgets.Edit.EmacsBindings
    Brick.Widgets.HelpMessage Brick.Widgets.List.Utils
    Brick.Widgets.WrappedText ConfigParser Data.Time.Ext DateParser
    Model View

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-iadd-1.3.21
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-iadd-1.3.21
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-iadd-1.3.21
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-iadd
hs-libraries:         HShledger-iadd-1.3.21-5xkwo85jtYWAm9M90YNBVb
depends:
    base-4.17.2.1 brick-2.2-BhxQOY8vbN83L7bH2hp8Sf containers-0.6.7
    directory-1.3.7.1 free-5.2-BhHkiE3xbmNE96fh3dkU7X
    hledger-lib-1.40-3E87q1E5b6L3h9rmVefd1H
    megaparsec-9.7.0-9KX7uZoGWhIHAGHTH7OWSU
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-mtl-0.2.1.0-LWyutRK1cqlCk2SYzoFhAy
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669
    optparse-applicative-0.18.1.0-B5S7p3yvcpkHKfw0kuCuBU text-2.0.2
    text-zipper-0.13-CUmD2Wdl1yA94qcKHp1WoZ time-1.12.2
    transformers-0.5.6.2
    unordered-containers-0.2.20-3NcLl7S6t7kAuh7l4Ieeoo
    vector-0.13.2.0-CQ8QMV1t4PN5YFZtNXivGS
    vty-6.2-LQ0PYKm9OCG4rLxpqs1ws7
    xdg-basedir-0.2.2-GUgbFy73ZJ02w1NqlBIm8a

haddock-interfaces:   /usr/share/doc/hledger-iadd/html/hledger-iadd.haddock
haddock-html:         /usr/share/doc/hledger-iadd/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

