#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger
version:              1.43.1
visibility:           public
id:                   hledger-1.43.1-JPfKANsWf7xFJIsJbgbdMJ
key:                  hledger-1.43.1-JPfKANsWf7xFJIsJbgbdMJ
license:              GPL-3.0-or-later
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Command-line interface for the hledger accounting system
description:
    The command-line interface for the hledger accounting system.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance, Console
abi:                  682611e139e01575e71a4f483f64231a
exposed:              True
exposed-modules:
    Hledger.Cli Hledger.Cli.Anchor Hledger.Cli.Anon
    Hledger.Cli.CliOptions Hledger.Cli.Commands
    Hledger.Cli.Commands.Accounts Hledger.Cli.Commands.Activity
    Hledger.Cli.Commands.Add Hledger.Cli.Commands.Aregister
    Hledger.Cli.Commands.Balance Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Check
    Hledger.Cli.Commands.Close Hledger.Cli.Commands.Codes
    Hledger.Cli.Commands.Commodities Hledger.Cli.Commands.Demo
    Hledger.Cli.Commands.Descriptions Hledger.Cli.Commands.Diff
    Hledger.Cli.Commands.Files Hledger.Cli.Commands.Help
    Hledger.Cli.Commands.Import Hledger.Cli.Commands.Incomestatement
    Hledger.Cli.Commands.Notes Hledger.Cli.Commands.Payees
    Hledger.Cli.Commands.Prices Hledger.Cli.Commands.Print
    Hledger.Cli.Commands.Register Hledger.Cli.Commands.Rewrite
    Hledger.Cli.Commands.Roi Hledger.Cli.Commands.Run
    Hledger.Cli.Commands.Setup Hledger.Cli.Commands.Stats
    Hledger.Cli.Commands.Tags Hledger.Cli.CompoundBalanceCommand
    Hledger.Cli.Conf Hledger.Cli.DocFiles Hledger.Cli.Script
    Hledger.Cli.Utils Hledger.Cli.Version

hidden-modules:       Paths_hledger
import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-1.43.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-1.43.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-1.43.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger
hs-libraries:         HShledger-1.43.1-JPfKANsWf7xFJIsJbgbdMJ
depends:
    Decimal-0.5.2-B3tMmlBSYIv6OiUJrzSwD6
    Diff-0.5-F16vv0Gp5cI3oyptWJ575y
    aeson-2.1.2.1-3LOl3stht3x9JybSpHkoQT
    ansi-terminal-1.0.2-2gkFCvfn2OGG2Y2ycr9zsg base-4.17.2.1
    bytestring-0.11.5.3 cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    containers-0.6.7 data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd
    directory-1.3.7.1 extra-1.7.16-JyMOdhEd59KIQI07ipQVcv
    filepath-1.4.2.2 githash-0.1.6.3-F2t5FCKeket9pA3b0xMoQY
    hashable-1.4.7.0-bh6X3bZPF56LQTYQ27khw haskeline-0.8.2
    hledger-lib-1.43.1-6fgTLCPnSJw4Boi5EjB8QD
    http-client-0.7.19-Je5Ncol09LTKkFF5WfHhv1
    http-types-0.12.4-6ojMayzAfwB91OTgOklzJ2
    lucid-2.11.20250303-2r5Doqcc4Mv7LkZkJhMHkr
    math-functions-0.3.4.4-AvUTIYfpNHfD89Fudwn9Jg
    megaparsec-9.7.0-FV2beEugwl3FKVu1jTXjCD
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    modern-uri-0.3.6.1-8TxU8glrHtWFgDvpwf93h mtl-2.2.2 process-1.6.18.0
    regex-tdfa-1.3.2.5-Gv6LsF4EJj23ouLVTe9nXQ
    req-3.13.4-HPvGSxX0ndvLZ8X98QqiTq
    safe-0.3.21-DkSUsNQd5PECw0GboXg9Ze
    shakespeare-2.1.4-JJd7S4Fbqoo2s9HA0NF3jR
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q
    tabular-0.2.2.8-GPlaI3PukxDKI4c6j3m1vm
    tasty-1.5.2-8iNYQiIlJsTE6YCTGAQ4WP
    temporary-1.3-7OlUYGsOxiE5dNsZFuxKnV text-2.0.2
    text-ansi-0.3.0.1-7adhcsigsEWD4QNNWlQIOJ time-1.12.2
    timeit-2.0-GSLifhpRLI5Gr54jWRx5t0 transformers-0.5.6.2
    unordered-containers-0.2.20.1-98Hg6PuNW0XDqLHXL1727Z
    utf8-string-1.0.2-4OrQf1vZkgOAJqnDO7nv41
    utility-ht-0.0.17.2-2kzIUfr5WsA1WYymwS72c1
    wizards-1.0.3-KdOLRFMRRl1t6euiwGd

haddock-interfaces:   /usr/share/doc/hledger/html/hledger.haddock
haddock-html:         /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

