#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger
version:              1.43.1
visibility:           public
id:                   hledger-1.43.1-HjZGm1j8a0UATQiwRQL0v7
key:                  hledger-1.43.1-HjZGm1j8a0UATQiwRQL0v7
license:              GPL-3.0-or-later
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Command-line interface for the hledger accounting system
description:
    The command-line interface for the hledger accounting system.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance, Console
abi:                  b9eab40b834c08bc042276f9461a6c80
exposed:              True
exposed-modules:
    Hledger.Cli Hledger.Cli.Anchor Hledger.Cli.Anon
    Hledger.Cli.CliOptions Hledger.Cli.Commands
    Hledger.Cli.Commands.Accounts Hledger.Cli.Commands.Activity
    Hledger.Cli.Commands.Add Hledger.Cli.Commands.Aregister
    Hledger.Cli.Commands.Balance Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Check
    Hledger.Cli.Commands.Close Hledger.Cli.Commands.Codes
    Hledger.Cli.Commands.Commodities Hledger.Cli.Commands.Demo
    Hledger.Cli.Commands.Descriptions Hledger.Cli.Commands.Diff
    Hledger.Cli.Commands.Files Hledger.Cli.Commands.Help
    Hledger.Cli.Commands.Import Hledger.Cli.Commands.Incomestatement
    Hledger.Cli.Commands.Notes Hledger.Cli.Commands.Payees
    Hledger.Cli.Commands.Prices Hledger.Cli.Commands.Print
    Hledger.Cli.Commands.Register Hledger.Cli.Commands.Rewrite
    Hledger.Cli.Commands.Roi Hledger.Cli.Commands.Run
    Hledger.Cli.Commands.Setup Hledger.Cli.Commands.Stats
    Hledger.Cli.Commands.Tags Hledger.Cli.CompoundBalanceCommand
    Hledger.Cli.Conf Hledger.Cli.DocFiles Hledger.Cli.Script
    Hledger.Cli.Utils Hledger.Cli.Version

hidden-modules:       Paths_hledger
import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-1.43.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-1.43.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-1.43.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger
hs-libraries:         HShledger-1.43.1-HjZGm1j8a0UATQiwRQL0v7
depends:
    Decimal-0.5.2-9mQhlsg54rVHyyIstbewRt
    Diff-0.5-CFajIZ8dkNLBAcT1NAzb1Z
    aeson-2.1.2.1-AErwMfn2r5g1Pc6FekWoJb
    ansi-terminal-1.0.2-Bnl76ueL4Li3NnUVLDNwn4 base-4.17.2.1
    bytestring-0.11.5.3 cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    containers-0.6.7 data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd
    directory-1.3.7.1 extra-1.7.16-3h3A56u6pun39B092rquhI
    filepath-1.4.2.2 githash-0.1.6.3-JMIH8bGGxq4JjQF4ufytkZ
    hashable-1.4.6.0-HNsjIjcKtfz4EPsBV3Crzv haskeline-0.8.2
    hledger-lib-1.43.1-HTaiz2fbXkl7hrLWWZ8fsu
    http-client-0.7.19-4UbGlDhlNmJ9JhWVX5eNPs
    http-types-0.12.4-8EgajALSM5xB8GFkN9ClFd
    lucid-2.11.20250303-2dh4xfQn3fKAVPtpSJVwcA
    math-functions-0.3.4.4-7ESDaarFEQE9v4MR7JQ1u6
    megaparsec-9.7.0-ATzV0kIhS1c1WF6GxcAl4n
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    modern-uri-0.3.6.1-BlYvql7NIXH2eYVqhoLDgG mtl-2.2.2
    process-1.6.18.0 regex-tdfa-1.3.2.4-E9frbDbU8Sy5RrbyJsGucy
    req-3.13.4-DbckxmGuIhB6DyOAqHRDYI
    safe-0.3.21-JY11j08EGF0I8tPaNSusR6
    shakespeare-2.1.4-4PJgJrCH8EmHC53xfWJnKr
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q
    tabular-0.2.2.8-GPlaI3PukxDKI4c6j3m1vm
    tasty-1.5.2-GhZ10z8ewJ5BcfKqIGg8kH
    temporary-1.3-5537yedaJYW2ftrfAfmMN5 text-2.0.2
    text-ansi-0.3.0.1-IUH7XN7CUK08tCJJgRPudx time-1.12.2
    timeit-2.0-GSLifhpRLI5Gr54jWRx5t0 transformers-0.5.6.2
    unordered-containers-0.2.20-2t1vPVJZrFoJrApu3o7oBM
    utf8-string-1.0.2-LtGEIYPp5RR87I6rMd4Fpy
    utility-ht-0.0.17.2-EvAbuSET9O89lKNFuR8ATK
    wizards-1.0.3-KdOLRFMRRl1t6euiwGd

haddock-interfaces:   /usr/share/doc/hledger/html/hledger.haddock
haddock-html:         /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

